/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.response;

import cool.taomu.framework.service.mqtt.broker.entity.ConnackEntity;
import cool.taomu.framework.service.mqtt.broker.inter.IResponse;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * CONNACK  V   |   2   |   服务端到客户端     |   连接报文确认
 */
@SuppressWarnings("all")
public class ConnackResponse implements IResponse<ConnackEntity> {
  private final Logger LOG = LoggerFactory.getLogger(ConnackResponse.class);
  
  @Override
  public MqttMessage response(final ConnackEntity entity) {
    this.LOG.info("执行了MQTT Connack 命令");
    MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.CONNACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
    MqttConnectReturnCode _code = entity.getCode();
    boolean _isSessionPresent = entity.isSessionPresent();
    MqttConnAckVariableHeader varHeader = new MqttConnAckVariableHeader(_code, _isSessionPresent);
    return new MqttConnAckMessage(header, varHeader);
  }
}
