/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.response;

import cool.taomu.framework.service.mqtt.broker.entity.PublishEntity;
import cool.taomu.framework.service.mqtt.broker.inter.IResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class PublishResponse implements IResponse<PublishEntity> {
  @Override
  public MqttMessage response(final PublishEntity entity) {
    Boolean _dup = entity.getDup();
    MqttQoS _qos = entity.getQos();
    MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBLISH, (_dup).booleanValue(), _qos, false, 0);
    String _topicName = entity.getTopicName();
    Integer _messageId = entity.getMessageId();
    MqttPublishVariableHeader varHeader = new MqttPublishVariableHeader(_topicName, (_messageId).intValue());
    ByteBuf heapBuf = null;
    byte[] _payload = entity.getPayload();
    boolean _tripleEquals = (_payload == null);
    if (_tripleEquals) {
      heapBuf = Unpooled.EMPTY_BUFFER;
    } else {
      try {
        heapBuf = Unpooled.wrappedBuffer(entity.getPayload());
      } catch (final Throwable _t) {
        if (_t instanceof IllegalArgumentException) {
          final IllegalArgumentException e = (IllegalArgumentException)_t;
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    return new MqttPublishMessage(header, varHeader, heapBuf);
  }
}
