/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.response;

import cool.taomu.framework.service.mqtt.broker.entity.SubAckEntity;
import cool.taomu.framework.service.mqtt.broker.entity.TopicEntity;
import cool.taomu.framework.service.mqtt.broker.inter.IResponse;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class SubAckResponse implements IResponse<SubAckEntity> {
  @Override
  public MqttMessage response(final SubAckEntity entity) {
    MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
    MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((entity.getMessageId()).intValue());
    List<Integer> _topicQos = this.getTopicQos(entity.getQos());
    MqttSubAckPayload _mqttSubAckPayload = new MqttSubAckPayload(_topicQos);
    return new MqttSubAckMessage(header, varHeader, _mqttSubAckPayload);
  }
  
  public List<Integer> getTopicQos(final List<TopicEntity> topics) {
    int _size = topics.size();
    ArrayList<Integer> qoss = new ArrayList<Integer>(_size);
    for (final TopicEntity topic : topics) {
      qoss.add(Integer.valueOf(topic.getQos()));
    }
    return qoss;
  }
}
