package cool.taomu.framework.service.rpc;

import java.net.InetSocketAddress;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class TRpcServer {
  public static void server(final String ip, final int port, final int minWorkerThreads, final int maxWorkerThreads, final TProcessor processor) {
    try {
      InetSocketAddress _inetSocketAddress = new InetSocketAddress(ip, port);
      TNonblockingServerSocket socket = new TNonblockingServerSocket(_inetSocketAddress);
      THsHaServer.Args arg = new THsHaServer.Args(socket).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
      TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
      arg.protocolFactory(_factory);
      TFramedTransport.Factory _factory_1 = new TFramedTransport.Factory();
      arg.transportFactory(_factory_1);
      TProcessorFactory _tProcessorFactory = new TProcessorFactory(processor);
      arg.processorFactory(_tProcessorFactory);
      THsHaServer server = new THsHaServer(arg);
      server.serve();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
