/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.service.mqtt.broker.MQTTHandler;
import cool.taomu.framework.service.mqtt.broker.MQTTSslHandler;
import cool.taomu.framework.service.rpc.Gateway;
import cool.taomu.framework.service.rpc.TRpcServer;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.ServiceLoader;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTBroker {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTBroker.class);
    private NioEventLoopGroup selectGroup;
    private NioEventLoopGroup ioGroup;
    private ChannelInboundHandlerAdapter handler = new MQTTHandler();
    private final ConfigureEntity config = ConfigureManage.loadConfig();
    private final int coreNumber = Runtime.getRuntime().availableProcessors();

    public MQTTBroker() {
        NioEventLoopGroup _nioEventLoopGroup_1;
        NioEventLoopGroup _nioEventLoopGroup;
        this.selectGroup = _nioEventLoopGroup = new NioEventLoopGroup(this.coreNumber);
        this.ioGroup = _nioEventLoopGroup_1 = new NioEventLoopGroup(this.coreNumber * 2);
    }

    public void startTcpServer() {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ServerBootstrap bootstrap = serverBootstrap.group((EventLoopGroup)this.selectGroup, (EventLoopGroup)this.ioGroup);
        ServerBootstrap channel = (ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class);
        ((ServerBootstrap)((ServerBootstrap)channel.option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)false).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
        channel.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                boolean _isUseSsl = MQTTBroker.this.config.getMqtt().isUseSsl();
                if (_isUseSsl) {
                    pipeline.addLast("ssl", (ChannelHandler)MQTTSslHandler.build(ch, MQTTBroker.this.config));
                }
                IdleStateHandler _idleStateHandler = new IdleStateHandler(60, 0, 0);
                pipeline.addLast("idleStateHandler", (ChannelHandler)_idleStateHandler);
                pipeline.addLast("mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
                MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
                pipeline.addLast("mqttDecoder", (ChannelHandler)_mqttDecoder);
                pipeline.addLast("nettyMqttHandler", (ChannelHandler)MQTTBroker.this.handler);
            }
        });
        Runtime _runtime = Runtime.getRuntime();
        _runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                MQTTBroker.this.selectGroup.shutdownGracefully();
                MQTTBroker.this.ioGroup.shutdownGracefully();
            }
        });
        Runnable _function = () -> {
            try {
                LOG.info("\u542f\u52a8MQTT\u4ee3\u7406\u670d\u52a1 ip: {} port: {}", (Object)this.config.getMqtt().getHostname(), (Object)this.config.getMqtt().getPort());
                bootstrap.bind(this.config.getMqtt().getHostname(), this.config.getMqtt().getPort().intValue()).sync();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        CommonUtils.exec(_function);
        ServiceLoader client = ServiceLoader.load(Gateway.Iface.class);
        Gateway.Iface _first = (Gateway.Iface)client.first();
        Gateway.Processor<Gateway.Iface> processor = new Gateway.Processor<Gateway.Iface>(_first);
        Integer _port = this.config.getMqtt().getPort();
        int _plus = _port + 1;
        TRpcServer.server(this.config.getMqtt().getHostname(), _plus, this.coreNumber, this.coreNumber * 2, processor);
    }
}

