/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.cache.SetCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.PubRelEntity;
import cool.taomu.framework.service.mqtt.broker.impl.response.PubRelResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="PUBREL")
public class PubRelRequest
implements IRequest {
    private final Logger LOG = LoggerFactory.getLogger(PubRelRequest.class);
    private SetCache<MessageEntity> cache = SetCache.getInstance();

    @Override
    public List<MqttMessage> request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        String clientId = CommonUtils.getClientId(ctx.channel());
        this.LOG.info("\u6267\u884c\u4e86MQTT PubRel \u547d\u4ee4 : " + clientId);
        Object _variableHeader = mqttMessage.variableHeader();
        MqttMessageIdVariableHeader idVariableHeader = (MqttMessageIdVariableHeader)_variableHeader;
        int msgId = idVariableHeader.messageId();
        Set qos2 = this.cache.get(CommonUtils.qos2Message(clientId));
        Iterator iterator = qos2.iterator();
        while (iterator.hasNext()) {
            MessageEntity q;
            MessageEntity msg = q = (MessageEntity)iterator.next();
            PubRelResponse _pubRelResponse = new PubRelResponse();
            PubRelEntity _pubRelEntity = new PubRelEntity(msgId);
            MqttMessage entity = _pubRelResponse.response(_pubRelEntity);
            msg.getSenderChannel().writeAndFlush((Object)entity);
            this.cache.remove(CommonUtils.qos2Message(clientId), (Serializable)msg);
            msg.setSenderChannel(ctx.channel());
            String senderId = msg.getSenderId();
            msg.setSenderId(clientId);
            this.cache.add(CommonUtils.qos2Message(senderId), (Serializable)msg);
        }
        return null;
    }
}

