/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.service.rpc.Gateway;
import cool.taomu.framework.service.rpc.TRpcServer;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.ServiceLoader;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MQTTBroker {
  private static final Logger LOG = LoggerFactory.getLogger(MQTTBroker.class);
  
  private NioEventLoopGroup selectGroup;
  
  private NioEventLoopGroup ioGroup;
  
  private ChannelInboundHandlerAdapter handler = new MQTTHandler();
  
  private final ConfigureEntity config = ConfigureManage.loadConfig();
  
  private final int coreNumber = Runtime.getRuntime().availableProcessors();
  
  public MQTTBroker() {
    NioEventLoopGroup _nioEventLoopGroup = new NioEventLoopGroup(this.coreNumber);
    this.selectGroup = _nioEventLoopGroup;
    NioEventLoopGroup _nioEventLoopGroup_1 = new NioEventLoopGroup((this.coreNumber * 2));
    this.ioGroup = _nioEventLoopGroup_1;
  }
  
  public void startTcpServer() {
    ServerBootstrap serverBootstrap = new ServerBootstrap();
    final ServerBootstrap bootstrap = serverBootstrap.group(this.selectGroup, this.ioGroup);
    ServerBootstrap channel = bootstrap.channel(NioServerSocketChannel.class);
    channel.<Integer>option(ChannelOption.SO_BACKLOG, Integer.valueOf(1024)).<Boolean>childOption(ChannelOption.TCP_NODELAY, Boolean.valueOf(false)).<Boolean>option(
      ChannelOption.SO_REUSEADDR, Boolean.valueOf(true)).<Boolean>childOption(ChannelOption.SO_KEEPALIVE, Boolean.valueOf(false));
    channel.childHandler(new ChannelInitializer<SocketChannel>() {
      @Override
      protected void initChannel(final SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        boolean _isUseSsl = MQTTBroker.this.config.getMqtt().isUseSsl();
        if (_isUseSsl) {
          pipeline.addLast("ssl", MQTTSslHandler.build(ch, MQTTBroker.this.config));
        }
        IdleStateHandler _idleStateHandler = new IdleStateHandler(60, 0, 0);
        pipeline.addLast("idleStateHandler", _idleStateHandler);
        pipeline.addLast("mqttEncoder", MqttEncoder.INSTANCE);
        MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
        pipeline.addLast("mqttDecoder", _mqttDecoder);
        pipeline.addLast("nettyMqttHandler", MQTTBroker.this.handler);
      }
    });
    Runtime _runtime = Runtime.getRuntime();
    _runtime.addShutdownHook(new Thread() {
      @Override
      public void run() {
        MQTTBroker.this.selectGroup.shutdownGracefully();
        MQTTBroker.this.ioGroup.shutdownGracefully();
      }
    });
    final Runnable _function = () -> {
      try {
        MQTTBroker.LOG.info("启动MQTT代理服务 ip: {} port: {}", this.config.getMqtt().getHostname(), this.config.getMqtt().getPort());
        bootstrap.bind(this.config.getMqtt().getHostname(), (this.config.getMqtt().getPort()).intValue()).sync();
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    };
    CommonUtils.exec(_function);
    ServiceLoader<Gateway.Iface> client = ServiceLoader.<Gateway.Iface>load(Gateway.Iface.class);
    Gateway.Iface _first = client.first();
    Gateway.Processor<Gateway.Iface> processor = new Gateway.Processor<Gateway.Iface>(_first);
    Integer _port = this.config.getMqtt().getPort();
    int _plus = ((_port).intValue() + 1);
    TRpcServer.server(this.config.getMqtt().getHostname(), _plus, this.coreNumber, (this.coreNumber * 2), processor);
  }
}
