/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.configure.entity.SslEntity;
import cool.taomu.framework.crypto.ssl.SslUtil;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class MQTTSslHandler {
  public static SslHandler build(final SocketChannel channel, final ConfigureEntity config) {
    try {
      SslEntity sslConfig = config.getMqtt().getSsl();
      String _keyStoreType = sslConfig.getKeyStoreType();
      SslUtil ssl = new SslUtil(_keyStoreType);
      KeyManagerFactory kmf = ssl.keyManageFactory(sslConfig.getKeyFilePath(), sslConfig.getManagerPwd(), sslConfig.getStorePwd());
      SslContextBuilder contextBuilder = SslContextBuilder.forServer(kmf);
      SslContext sslContext = contextBuilder.sslProvider(SslProvider.valueOf("JDK")).build();
      SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), channel.remoteAddress().getHostString(), 
        channel.remoteAddress().getPort());
      sslEngine.setUseClientMode(false);
      boolean _isUseClientCA = sslConfig.isUseClientCA();
      if (_isUseClientCA) {
        contextBuilder.clientAuth(ClientAuth.REQUIRE);
        contextBuilder.trustManager(ssl.trustManageFactory());
        sslEngine.setNeedClientAuth(true);
      }
      return new SslHandler(sslEngine);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
