/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class TopicEntity {
  private String clientId;
  
  private String name;
  
  private int qos;
  
  public TopicEntity(final String name, final int value) {
    this.name = name;
    this.qos = value;
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  public void setName(final String name) {
    this.name = name;
  }
  
  @Pure
  public int getQos() {
    return this.qos;
  }
  
  public void setQos(final int qos) {
    this.qos = qos;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("clientId", this.clientId);
    b.add("name", this.name);
    b.add("qos", this.qos);
    return b.toString();
  }
}
