/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.cache.SetCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.PubCompEntity;
import cool.taomu.framework.service.mqtt.broker.impl.response.PubCompResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * PUBCOMP  |   7   |   两个方向都允许     |   QoS 2 消息发布完成(保证交付第三步)
 */
@Alias(value = "PUBCOMP")
@SuppressWarnings("all")
public class PubCompRequest implements IRequest {
  private final Logger LOG = LoggerFactory.getLogger(PubCompRequest.class);
  
  private SetCache<MessageEntity> cache = SetCache.<MessageEntity>getInstance();
  
  @Override
  public List<MqttMessage> request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = CommonUtils.getClientId(ctx.channel());
    this.LOG.info(("执行了MQTT PubComp 命令 : " + clientId));
    int msgId = CommonUtils.getMessageId(mqttMessage);
    Set<MessageEntity> qos2 = this.cache.get(CommonUtils.qos2Message(clientId));
    for (final MessageEntity q : qos2) {
      {
        MessageEntity msg = ((MessageEntity) q);
        PubCompResponse _pubCompResponse = new PubCompResponse();
        PubCompEntity _pubCompEntity = new PubCompEntity(Integer.valueOf(msgId));
        MqttMessage resp = _pubCompResponse.response(_pubCompEntity);
        msg.getSenderChannel().writeAndFlush(resp);
        this.cache.remove(CommonUtils.qos2Message(clientId), msg);
      }
    }
    return null;
  }
}
