package cool.taomu.framework.service.rpc;

import com.google.gson.Gson;
import cool.taomu.framework.cache.KeyValueCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.impl.PublishObservable;
import cool.taomu.framework.service.mqtt.broker.inter.IPublishObserver;
import cool.taomu.framework.service.rpc.Gateway;
import cool.taomu.framework.utils.reflect.CallSiteUtils;
import cool.taomu.framework.utils.runtime.RuntimeInfo;
import cool.taomu.framework.utils.spi.ServiceLoader;
import org.apache.thrift.TException;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class MqttCluster implements Gateway.Iface {
  private KeyValueCache cache = KeyValueCache.getInstance();
  
  @Override
  public Response loadInfo() throws TException {
    Gson _gson = new Gson();
    RuntimeInfo _runtimeInfo = new RuntimeInfo();
    String _json = _gson.toJson(_runtimeInfo);
    return new Response(200, _json);
  }
  
  @Override
  public Response publish(final String source, final String data) throws TException {
    this.cache.store(source, new Gson().<MessageEntity>fromJson(data, MessageEntity.class));
    PublishObservable.getInstance().start(source, IPublishObserver.Type.MESSAGE);
    return new Response(200, "");
  }
  
  @Override
  public Response refresh(final String key) throws TException {
    this.cache.refresh(key);
    return new Response(200, "");
  }
  
  /**
   * serviceName inteface
   * callSite impl method
   * arg args
   */
  @Override
  public Response call(final String serviceName, final String callSite, final String arg) throws TException {
    try {
      Class<?> zlass = Thread.currentThread().getContextClassLoader().loadClass(serviceName);
      FunctionalInterface _annotation = zlass.<FunctionalInterface>getAnnotation(FunctionalInterface.class);
      boolean _tripleNotEquals = (_annotation != null);
      if (_tripleNotEquals) {
        CallSiteUtils csu = new CallSiteUtils(zlass);
        ServiceLoader<?> sl = ServiceLoader.load(zlass);
        Class<?> zlassImpl = sl.getZlass(callSite);
        Object result = csu.bind(zlassImpl, arg);
        String _json = new Gson().toJson(result);
        return new Response(200, _json);
      }
      return new Response(404, "");
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
        return new Response(404, "");
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
