package cool.taomu.framework.service.rpc;

import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@SuppressWarnings("all")
public abstract class TRpcClient {
  public abstract <T extends Object> void call(final TProtocol protocol);
  
  public static <T extends Object> void client(final String host, final int port, final int maxLength, final TRpcClient client) {
    try {
      try (TFramedTransport tTransport = new Function0<TFramedTransport>() {
        @Override
        public TFramedTransport apply() {
          try {
            TSocket _tSocket = new TSocket(host, port);
            return new TFramedTransport(_tSocket, maxLength);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        TCompactProtocol protocol = new TCompactProtocol(tTransport);
        tTransport.open();
        client.<Object>call(protocol);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
