/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.utils;

import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.HostEntity;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class NTPUnixTimestamp {
  private static final Logger LOG = LoggerFactory.getLogger(NTPUnixTimestamp.class);
  
  private static HostEntity HOST = null;
  
  public NTPUnixTimestamp() {
    if ((NTPUnixTimestamp.HOST == null)) {
      NTPUnixTimestamp.HOST = ConfigureManage.loadConfig().getNtp();
    }
  }
  
  public long unixTimestamp() {
    try {
      if (((NTPUnixTimestamp.HOST != null) && (!NTPUnixTimestamp.HOST.getIp().equals("None")))) {
        NTPUnixTimestamp.LOG.info("get ntp current time millis");
        NTPUDPClient ntpUdpClient = new NTPUDPClient();
        InetAddress inetAddress = InetAddress.getByName(NTPUnixTimestamp.HOST.getIp());
        ntpUdpClient.setDefaultTimeout(500);
        TimeInfo timeInfo = ntpUdpClient.getTime(inetAddress, (NTPUnixTimestamp.HOST.getPort()).intValue());
        long _time = timeInfo.getMessage().getOriginateTimeStamp().getTime();
        return (_time / 1000);
      }
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException ex = (IOException)_t;
        NTPUnixTimestamp.LOG.error("NTP Error:{}", ex.getMessage());
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    NTPUnixTimestamp.LOG.info("get local current time millis");
    long _currentTimeMillis = System.currentTimeMillis();
    return (_currentTimeMillis / 1000);
  }
  
  public static void main(final String[] args) {
  }
}
