/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.ServiceLoader;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MQTTHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(MQTTHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object obj) {
        MqttMessage mqttMessage = (MqttMessage)obj;
        if (mqttMessage != null && mqttMessage.decoderResult().isSuccess()) {
            MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
            String typeName = messageType.name();
            this.LOG.debug("\u6536\u5230\u8bf7\u6c42\u7c7b\u578b\uff1a{}", (Object)typeName);
            IRequest msg = (IRequest)ServiceLoader.load(IRequest.class).get(typeName);
            Runnable _function = () -> {
                List<MqttMessage> msgs = msg.request(ctx, mqttMessage);
                if (msgs != null) {
                    Consumer<MqttMessage> _function_1 = r -> {
                        Assert.assertNotNull((Object)r);
                        ctx.writeAndFlush(r);
                    };
                    IterableExtensions.filterNull(msgs).forEach(_function_1);
                }
            };
            CommonUtils.exec(_function);
        } else {
            ctx.close();
        }
    }
}

