/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.cache.KeyValueCache;
import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.entity.ConnackEntity;
import cool.taomu.framework.service.mqtt.broker.entity.WillEntity;
import cool.taomu.framework.service.mqtt.broker.impl.response.ConnackResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="CONNECT")
public class ConnectRequest
implements IRequest {
    private final Logger LOG = LoggerFactory.getLogger(ConnectRequest.class);
    private KeyValueCache cache = KeyValueCache.getInstance();
    private ChannelHandlerContext ctx = null;

    public boolean checkVersion(int mqttVersion) {
        switch (mqttVersion) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean checkClientId(String clientId) {
        boolean _equals = CommonUtils.getClientId(this.ctx.channel()).equals(clientId);
        return _equals;
    }

    public boolean checkAuthorized(String addr, String clientId) {
        return true;
    }

    public boolean checkUserAuth(String clientId, String userName, byte[] password) {
        ConfigureEntity config = ConfigureManage.loadConfig();
        boolean _isAnonymous = config.getMqtt().isAnonymous();
        if (_isAnonymous) {
            return true;
        }
        return userName.equals(config.getMqtt().getUsername()) && config.getMqtt().getPassword().equals(new String(password));
    }

    public boolean keepAlive(String clientId, ChannelHandlerContext ctx, int heatbeatSec) {
        this.LOG.info("\u8bbe\u7f6ekeep alive");
        int keepAlive = (int)((float)heatbeatSec * 1.5f);
        boolean _contains = ctx.pipeline().names().contains("idleStateHandler");
        if (_contains) {
            ctx.pipeline().remove("idleStateHandler");
        }
        ChannelPipeline _pipeline = ctx.pipeline();
        IdleStateHandler _idleStateHandler = new IdleStateHandler(keepAlive, 0, 0);
        _pipeline.addFirst("idleStateHandler", (ChannelHandler)_idleStateHandler);
        return true;
    }

    @Override
    public List<MqttMessage> request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        this.LOG.info("\u6267\u884c\u4e86MQTT Connect \u547d\u4ee4");
        MqttConnectMessage connectMessage = (MqttConnectMessage)mqttMessage;
        int mqttVersion = connectMessage.variableHeader().version();
        boolean cleanSession = connectMessage.variableHeader().isCleanSession();
        String clientId = connectMessage.payload().clientIdentifier();
        CommonUtils.setClientId(ctx.channel(), clientId);
        String userName = connectMessage.payload().userName();
        byte[] password = connectMessage.payload().passwordInBytes();
        boolean sessionPresent = false;
        this.LOG.info("clientId:{},cleanSession:{}", (Object)clientId, (Object)cleanSession);
        ConnackEntity entity = null;
        try {
            boolean _not;
            this.ctx = ctx;
            boolean _checkVersion = this.checkVersion(mqttVersion);
            boolean bl = _not = !_checkVersion;
            if (_not) {
                ConnackEntity _connackEntity;
                entity = _connackEntity = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION, sessionPresent);
            } else {
                boolean _not_1;
                boolean _checkClientId = this.checkClientId(clientId);
                boolean bl2 = _not_1 = !_checkClientId;
                if (_not_1) {
                    ConnackEntity _connackEntity_1;
                    entity = _connackEntity_1 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED, sessionPresent);
                } else {
                    boolean _not_2;
                    boolean _checkAuthorized = this.checkAuthorized(CommonUtils.getRemoteAddr(ctx.channel()), clientId);
                    boolean bl3 = _not_2 = !_checkAuthorized;
                    if (_not_2) {
                        ConnackEntity _connackEntity_2;
                        entity = _connackEntity_2 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED, sessionPresent);
                    } else {
                        boolean _not_3;
                        boolean _checkUserAuth = this.checkUserAuth(clientId, userName, password);
                        boolean bl4 = _not_3 = !_checkUserAuth;
                        if (_not_3) {
                            ConnackEntity _connackEntity_3;
                            entity = _connackEntity_3 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD, sessionPresent);
                        } else {
                            ConnackEntity _connackEntity_4;
                            boolean _not_4;
                            int heartbeatSec = connectMessage.variableHeader().keepAliveTimeSeconds();
                            boolean _keepAlive = this.keepAlive(clientId, ctx, heartbeatSec);
                            boolean bl5 = _not_4 = !_keepAlive;
                            if (_not_4) {
                                String failure = String.format("set heartbeat failure clientId:%s,heartbeatSec:%d", clientId, heartbeatSec);
                                throw new Exception(failure);
                            }
                            sessionPresent = this.createSession(clientId, ctx, cleanSession);
                            this.storeWill(connectMessage, clientId);
                            entity = _connackEntity_4 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_ACCEPTED, sessionPresent);
                        }
                    }
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                ConnackEntity _connackEntity_5;
                Exception ex = (Exception)_t;
                this.LOG.info("Service Unavailable:", (Throwable)ex);
                entity = _connackEntity_5 = new ConnackEntity(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE, sessionPresent);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        MqttMessage _response = new ConnackResponse().response(entity);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new MqttMessage[]{_response}));
    }

    protected String storeWill(MqttConnectMessage connectMessage, String clientId) {
        String _xifexpression = null;
        boolean _isWillFlag = connectMessage.variableHeader().isWillFlag();
        if (_isWillFlag) {
            String _xblockexpression = null;
            this.LOG.info("\u4fdd\u5b58Will\u6d88\u606f \uff1a clientId:{}", (Object)clientId);
            WillEntity will = new WillEntity();
            will.setClientId(clientId);
            will.setRetain(connectMessage.variableHeader().isWillRetain());
            will.setQos(MqttQoS.valueOf((int)connectMessage.variableHeader().willQos()));
            will.setTopic(connectMessage.payload().willTopic());
            will.setWill(true);
            will.setPayload(connectMessage.payload().willMessageInBytes());
            _xifexpression = _xblockexpression = this.cache.store(CommonUtils.will(clientId), (Serializable)will);
        }
        return _xifexpression;
    }

    protected Boolean createSession(String clientId, ChannelHandlerContext ctx, boolean cleanSession) {
        ClientSessionEntity _clientSessionEntity;
        ClientSessionEntity mqttSession = new ClientSessionEntity();
        boolean sessionPresent = false;
        mqttSession = _clientSessionEntity = new ClientSessionEntity();
        mqttSession.setClientId(clientId);
        mqttSession.setCtx(ctx);
        mqttSession.setCleanStatus(cleanSession);
        if (!cleanSession) {
            sessionPresent = true;
        }
        this.cache.store(CommonUtils.session(clientId), (Serializable)mqttSession);
        return sessionPresent;
    }
}

