/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.cache.SetCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.PubCompEntity;
import cool.taomu.framework.service.mqtt.broker.impl.response.PubCompResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="PUBCOMP")
public class PubCompRequest
implements IRequest {
    private final Logger LOG = LoggerFactory.getLogger(PubCompRequest.class);
    private SetCache<MessageEntity> cache = SetCache.getInstance();

    @Override
    public List<MqttMessage> request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        String clientId = CommonUtils.getClientId(ctx.channel());
        this.LOG.info("\u6267\u884c\u4e86MQTT PubComp \u547d\u4ee4 : " + clientId);
        int msgId = CommonUtils.getMessageId(mqttMessage);
        Set qos2 = this.cache.get(CommonUtils.qos2Message(clientId));
        Iterator iterator = qos2.iterator();
        while (iterator.hasNext()) {
            MessageEntity q;
            MessageEntity msg = q = (MessageEntity)iterator.next();
            PubCompResponse _pubCompResponse = new PubCompResponse();
            PubCompEntity _pubCompEntity = new PubCompEntity(msgId);
            MqttMessage resp = _pubCompResponse.response(_pubCompEntity);
            msg.getSenderChannel().writeAndFlush((Object)resp);
            this.cache.remove(CommonUtils.qos2Message(clientId), (Serializable)msg);
        }
        return null;
    }
}

