/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.service.mqtt.broker.entity.SubAckEntity;
import cool.taomu.framework.service.mqtt.broker.entity.TopicEntity;
import cool.taomu.framework.service.mqtt.broker.impl.Publish;
import cool.taomu.framework.service.mqtt.broker.impl.PublishObservable;
import cool.taomu.framework.service.mqtt.broker.impl.request.ConnectRequest;
import cool.taomu.framework.service.mqtt.broker.impl.response.PublishResponse;
import cool.taomu.framework.service.mqtt.broker.impl.response.SubAckResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IPublishObserver;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="SUBSCRIBE")
public class SubscribeRequest
implements IRequest {
    private final Logger LOG = LoggerFactory.getLogger(ConnectRequest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MqttMessage> request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        try {
            ArrayList<TopicEntity> validTopicList;
            String clientId = CommonUtils.getClientId(ctx.channel());
            if (clientId == null) {
                Thread.sleep(100L);
                clientId = CommonUtils.getClientId(ctx.channel());
            }
            this.LOG.info("\u6267\u884c\u4e86MQTT Subscribe \u547d\u4ee4 : " + clientId);
            MqttSubscribeMessage subscribeMessage = (MqttSubscribeMessage)mqttMessage;
            int messageId = subscribeMessage.variableHeader().messageId();
            ArrayList<TopicEntity> arrayList = validTopicList = this.registerTopics(ctx, subscribeMessage.payload().topicSubscriptions());
            synchronized (arrayList) {
                if (validTopicList == null || validTopicList.size() == 0) {
                    this.LOG.info(String.format("Valid all subscribe topic failure,messageId:%s", messageId));
                    return null;
                }
                SubAckEntity entity = new SubAckEntity(messageId, validTopicList);
                this.LOG.info(entity.toString());
                PublishObservable.getInstance().start(clientId, IPublishObserver.Type.RETAIN);
                MqttMessage _response = new SubAckResponse().response(entity);
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new MqttMessage[]{_response}));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<TopicEntity> registerTopics(ChannelHandlerContext ctx, List<MqttTopicSubscription> topics) {
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            String clientId = CommonUtils.getClientId(ctx.channel());
            ArrayList<TopicEntity> topicList = new ArrayList<TopicEntity>();
            for (MqttTopicSubscription subscription : topics) {
                String _picName = subscription.topicName();
                int _value = subscription.qualityOfService().value();
                TopicEntity topic = new TopicEntity(_picName, _value);
                topic.setClientId(clientId);
                Perl5Util p5 = new Perl5Util();
                boolean _match = p5.match("/^[A-Za-z0-9]+([\\/A-Za-z0-9_]*|\\/\\+||\\/\\#)$/", topic.getName());
                if (_match) {
                    PublishResponse _publishResponse = new PublishResponse();
                    Publish publish2 = new Publish(topic, _publishResponse);
                    PublishObservable.getInstance().register(clientId, publish2);
                }
                topicList.add(topic);
            }
            return topicList;
        }
    }
}

