/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.utils;

import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class CommonUtils {
    private static final AttributeKey<String> clientIdAttr = AttributeKey.valueOf((String)"CLIENT_ID");
    private static ExecutorService exec = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    });

    public static String getRemoteAddr(Channel channel) {
        boolean _greaterThan;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String _xifexpression = null;
        _xifexpression = remote != null ? remote.toString() : "";
        String addr = _xifexpression;
        int _length = addr.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static void setClientId(Channel channel, String clientId) {
        channel.attr(clientIdAttr).set((Object)clientId);
    }

    public static String getClientId(Channel channel) {
        return (String)channel.attr(clientIdAttr).get();
    }

    public static int getMessageId(MqttMessage mqttMessage) {
        Object _variableHeader = mqttMessage.variableHeader();
        MqttMessageIdVariableHeader varHeader = (MqttMessageIdVariableHeader)_variableHeader;
        return varHeader.messageId();
    }

    public static int getQos(int qos1, int qos2) {
        if (qos1 < qos2) {
            return qos1;
        }
        return qos2;
    }

    public static String will(String id) {
        return "mqtt-will-" + id;
    }

    public static String session(String id) {
        return "mqtt-session-" + id;
    }

    public static String retain(String id) {
        return "mqtt-retain-" + id;
    }

    public static String qos2Message(String id) {
        return "mqtt-qos2-message" + id;
    }

    public static void exec(Runnable r) {
        exec.execute(r);
    }

    public static Future<?> submit(Runnable r) {
        return exec.submit(r);
    }

    public static void shutdown() {
        boolean _not;
        boolean _isShutdown = exec.isShutdown();
        boolean bl = _not = !_isShutdown;
        if (_not) {
            exec.shutdown();
        }
    }
}

