/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.service.utils;

import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.HostEntity;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTPUnixTimestamp {
    private static final Logger LOG = LoggerFactory.getLogger(NTPUnixTimestamp.class);
    private static HostEntity HOST = null;

    public NTPUnixTimestamp() {
        if (HOST == null) {
            HOST = ConfigureManage.loadConfig().getNtp();
        }
    }

    public long unixTimestamp() {
        try {
            if (HOST != null && !HOST.getIp().equals("None")) {
                LOG.info("get ntp current time millis");
                NTPUDPClient ntpUdpClient = new NTPUDPClient();
                InetAddress inetAddress = InetAddress.getByName(HOST.getIp());
                ntpUdpClient.setDefaultTimeout(500);
                TimeInfo timeInfo = ntpUdpClient.getTime(inetAddress, HOST.getPort().intValue());
                long _time = timeInfo.getMessage().getOriginateTimeStamp().getTime();
                return _time / 1000L;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException ex = (IOException)_t;
                LOG.error("NTP Error:{}", (Object)ex.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        LOG.info("get local current time millis");
        long _currentTimeMillis = System.currentTimeMillis();
        return _currentTimeMillis / 1000L;
    }

    public static void main(String[] args) {
    }
}

