package cool.taomu.framework.spring.plugin;

import cool.taomu.framework.utils.spi.ISpringPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

@SuppressWarnings("all")
public class TaomuSpringPlugin implements ISpringPlugin {
  private final Logger LOG = LoggerFactory.getLogger(TaomuSpringPlugin.class);
  
  private ApplicationContext applicationContext;
  
  public TaomuSpringPlugin(final GenericApplicationContext applicationContext) {
    this.applicationContext = applicationContext;
  }
  
  @Override
  public Object getBeanObject(final Class<?> zlass) {
    this.LOG.info(zlass.getName());
    this.register(zlass.getName(), zlass);
    return this.applicationContext.getBean(zlass.getName());
  }
  
  public void register(final String key, final Class<?> zlass) {
    BeanDefinitionBuilder bean = BeanDefinitionBuilder.genericBeanDefinition(zlass);
    ConfigurableApplicationContext config = ((ConfigurableApplicationContext) this.applicationContext);
    ConfigurableListableBeanFactory _beanFactory = config.getBeanFactory();
    DefaultListableBeanFactory registry = ((DefaultListableBeanFactory) _beanFactory);
    registry.setAllowBeanDefinitionOverriding(true);
    boolean _containsBeanDefinition = registry.containsBeanDefinition(key);
    if (_containsBeanDefinition) {
      registry.removeBeanDefinition(key);
    }
    registry.registerBeanDefinition(key, bean.getRawBeanDefinition());
  }
}
