/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.container;

import cool.taomu.framework.inter.IBeanContainer;
import cool.taomu.framework.spi.TmServiceLoader;
import cool.taomu.framework.spi.annotation.ISpi;
import cool.taomu.framework.spi.annotation.Spi;
import cool.taomu.framework.utils.TmClassLoader;
import cool.taomu.framework.utils.TmFileUtils;
import cool.taomu.framework.utils.reflect.ReflectUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class BeanContainer implements IBeanContainer {
  private static final Logger LOG = LoggerFactory.getLogger(BeanContainer.class);
  
  private Map<String, TmClassLoader> tclMapping = new HashMap<String, TmClassLoader>();
  
  private Map<String, Object> singletonMap = new HashMap<String, Object>();
  
  private TmServiceLoader sloader = new TmServiceLoader();
  
  public BeanContainer() {
    this.singletonMap.put("TmBeanContainer", this);
  }
  
  @Override
  public void scanning(final String path) {
    TmClassLoader tcl = new TmClassLoader(path);
    this.loadSpi(path, tcl);
    this.tclMapping.put(path, tcl);
  }
  
  private TmClassLoader getClassLoader(final String name) {
    final Function1<TmClassLoader, Boolean> _function = (TmClassLoader it) -> {
      try {
        Class<?> zlass = it.loadClass(name);
        if ((zlass != null)) {
          return Boolean.valueOf(true);
        }
        return Boolean.valueOf(false);
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    };
    TmClassLoader tcl = IterableExtensions.<TmClassLoader>findFirst(this.tclMapping.values(), _function);
    return tcl;
  }
  
  @Override
  public Object getBean(final String name, final Object... args) {
    try {
      TmClassLoader tcl = this.getClassLoader(name);
      Class<?> zlass = tcl.loadClass(name);
      synchronized (zlass) {
        Spi spi = zlass.<Spi>getAnnotation(Spi.class);
        BeanContainer.LOG.debug("getBeadn {} ", zlass.getName());
        if ((((spi != null) && spi.singleton()) && this.singletonMap.containsKey(spi.value()))) {
          BeanContainer.LOG.debug("单例类 {}", zlass.getName());
          return this.singletonMap.get(spi.value());
        }
        final Object zlassObj = ReflectUtils.newInstance(zlass, args);
        Field[] superFields = zlass.getSuperclass().getDeclaredFields();
        Field[] fields = zlass.getDeclaredFields();
        this.fieldInstance(fields, zlassObj, name);
        this.fieldInstance(superFields, zlassObj, name);
        return zlassObj;
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected void fieldInstance(final Field[] fields, final Object zlassObj, final String name) {
    final Function1<Field, Boolean> _function = (Field it) -> {
      boolean _xblockexpression = false;
      {
        it.setAccessible(true);
        Spi spi = it.<Spi>getAnnotation(Spi.class);
        _xblockexpression = ((spi != null) && (!spi.value().equals("")));
      }
      return Boolean.valueOf(_xblockexpression);
    };
    final Consumer<Field> _function_1 = (Field it) -> {
      try {
        Spi spi = it.<Spi>getAnnotation(Spi.class);
        if ((spi.singleton() && this.singletonMap.containsKey(spi.value()))) {
          Object sobj = this.singletonMap.get(spi.value());
          BeanContainer.LOG.debug("从单例取值 {}", sobj.getClass().getName());
          it.set(zlassObj, sobj);
        } else {
          Class<?> _xifexpression = null;
          Class<?> _svc = spi.svc();
          boolean _tripleEquals = (_svc == Void.class);
          if (_tripleEquals) {
            _xifexpression = this.sloader.getBean(it.getType(), spi.value());
          } else {
            _xifexpression = this.sloader.getBean(spi.svc(), spi.value());
          }
          Class<?> tsl = _xifexpression;
          Object instance = this.getBean(tsl.getName());
          boolean _singleton = spi.singleton();
          if (_singleton) {
            BeanContainer.LOG.debug("记录单例对象 {}", instance.getClass().getName());
            this.singletonMap.put(spi.value(), instance);
          }
          it.set(zlassObj, instance);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception ex = (Exception)_t;
          BeanContainer.LOG.info("获取实例错误", ex);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    };
    IterableExtensions.<Field>filter(((Iterable<Field>)Conversions.doWrapArray(fields)), _function).forEach(_function_1);
  }
  
  @Override
  public void loadSpi(final String path, final ClassLoader tcl) {
    File _file = new File(path);
    Set<String> jars = TmFileUtils.scanningFile(_file);
    final Function1<String, Boolean> _function = (String it) -> {
      return Boolean.valueOf(it.endsWith(".jar"));
    };
    jars = IterableExtensions.<String>toSet(IterableExtensions.<String>filter(jars, _function));
    final Consumer<String> _function_1 = (String it) -> {
      BeanContainer.LOG.info(("loadSpi:" + it));
      File _file_1 = new File(it);
      HashSet<String> zlassPaths = TmFileUtils.scanningJar(_file_1, null);
      final Function1<String, Boolean> _function_2 = (String it_1) -> {
        return Boolean.valueOf(it_1.endsWith(".class"));
      };
      final Consumer<String> _function_3 = (String it_1) -> {
        try {
          String zlassPackage = it_1.replace(".class", "").replaceAll("/", ".");
          Perl5Util p5 = new Perl5Util();
          boolean _match = p5.match("/module\\-info|META\\-INF/", zlassPackage);
          boolean _not = (!_match);
          if (_not) {
            BeanContainer.LOG.info(("加载类:" + zlassPackage));
            try {
              final Class<?> loader = tcl.loadClass(zlassPackage);
              boolean _isInterface = loader.isInterface();
              boolean _not_1 = (!_isInterface);
              if (_not_1) {
                final Spi spi = loader.<Spi>getAnnotation(Spi.class);
                if ((spi != null)) {
                  Class<?> _svc = spi.svc();
                  boolean _tripleEquals = (_svc == Void.class);
                  if (_tripleEquals) {
                    final Consumer<Class<?>> _function_4 = (Class<?> it_2) -> {
                      ISpi ispi = it_2.<ISpi>getAnnotation(ISpi.class);
                      if ((ispi != null)) {
                        this.sloader.add(it_2, spi.value(), loader);
                      }
                    };
                    ((List<Class<?>>)Conversions.doWrapArray(loader.getInterfaces())).forEach(_function_4);
                  } else {
                    this.sloader.add(spi.svc(), spi.value(), loader);
                  }
                }
              }
            } catch (final Throwable _t) {
              if (_t instanceof NoClassDefFoundError || _t instanceof ArrayStoreException) {
                final Throwable ex = (Throwable)_t;
                BeanContainer.LOG.debug("记录：", ex);
              } else {
                throw Exceptions.sneakyThrow(_t);
              }
            }
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      IterableExtensions.<String>filter(zlassPaths, _function_2).forEach(_function_3);
    };
    jars.forEach(_function_1);
  }
}
