package cool.taomu.framework.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.google.common.collect.ArrayListMultimap;

import cool.taomu.framework.inter.IObservable;

public abstract class AObservable<T extends Object> implements IObservable<T> {
	protected final ArrayListMultimap<Object, T> providers = ArrayListMultimap.<Object, T>create();
	//clientId topic+qos message

	protected final static ExecutorService exec = Executors.newCachedThreadPool();

	static {
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				exec.shutdown();
			}
		});
	}

	public void register(final Object arg, final T observer) {
		this.providers.put(arg, observer);
	}

	public void unregister(final Object arg) {
		this.providers.removeAll(arg);
	}
}
