package cool.taomu.framework.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

@SuppressWarnings("all")
public class ExecutorUtils {
  private static ExecutorService exec = Executors.newCachedThreadPool(new ThreadFactory() {
    @Override
    public Thread newThread(final Runnable r) {
      return new Thread(r);
    }
  });
  
  public static void exec(final Runnable r) {
    ExecutorUtils.exec.execute(r);
  }
  
  public static Future<?> submit(final Runnable r) {
    return ExecutorUtils.exec.submit(r);
  }
  
  public static void shutdown() {
    boolean _isShutdown = ExecutorUtils.exec.isShutdown();
    boolean _not = (!_isShutdown);
    if (_not) {
      ExecutorUtils.exec.shutdown();
    }
  }
}
