package cool.taomu.framework.utils;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TmFileUtils {
  private static final Logger LOG = LoggerFactory.getLogger(TmFileUtils.class);
  
  private static void scanning(final File file, final Set<String> paths) {
    File[] files = file.listFiles();
    final File[] _converted_files = (File[])files;
    int _size = ((List<File>)Conversions.doWrapArray(_converted_files)).size();
    String _plus = ("" + Integer.valueOf(_size));
    TmFileUtils.LOG.info(_plus);
    for (final File cf : files) {
      boolean _isDirectory = cf.isDirectory();
      if (_isDirectory) {
        TmFileUtils.scanning(cf, paths);
      } else {
        boolean _isFile = cf.isFile();
        if (_isFile) {
          String path = cf.getAbsolutePath();
          TmFileUtils.LOG.info(path);
          paths.add(path);
        }
      }
    }
  }
  
  public static HashSet<String> scanningFile(final File file) {
    HashSet<String> paths = new HashSet<String>();
    TmFileUtils.scanning(file, paths);
    return paths;
  }
  
  public static HashSet<String> scanningJar(final File file, final String namedPath) {
    try {
      boolean _endsWith = file.getPath().endsWith(".jar");
      if (_endsWith) {
        HashSet<String> paths = new HashSet<String>();
        try (JarFile jfile = new Function0<JarFile>() {
          @Override
          public JarFile apply() {
            try {
              return new JarFile(file);
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        }.apply()) {
          Enumeration<JarEntry> files = jfile.entries();
          while (files.hasMoreElements()) {
            {
              JarEntry _nextElement = files.nextElement();
              JarEntry entry = ((JarEntry) _nextElement);
              boolean _isDirectory = entry.isDirectory();
              boolean _not = (!_isDirectory);
              if (_not) {
                String path = entry.getName();
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(namedPath);
                boolean _not_1 = (!_isNullOrEmpty);
                if (_not_1) {
                  Perl5Util p5 = new Perl5Util();
                  String named = namedPath.replace("/", "\\/");
                  boolean _match = p5.match((("/" + named) + "/"), path);
                  if (_match) {
                    paths.add(path);
                  }
                } else {
                  paths.add(path);
                }
              }
            }
          }
        }
        return paths;
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static HashMap<String, byte[]> readJarClass(final File file) {
    try {
      HashMap<String, byte[]> mapping = CollectionLiterals.<String, byte[]>newHashMap();
      try (JarFile jar = new Function0<JarFile>() {
        @Override
        public JarFile apply() {
          try {
            return new JarFile(file);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
          {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            boolean _endsWith = name.endsWith(".class");
            if (_endsWith) {
              String zlass = name.replace(".class", "").replaceAll("/", ".");
              boolean _containsKey = mapping.containsKey(zlass);
              boolean _not = (!_containsKey);
              if (_not) {
                InputStream input = jar.getInputStream(entry);
                mapping.put(zlass, IOUtils.toByteArray(input));
              }
            }
          }
        }
      }
      return mapping;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] args) {
    File _file = new File("/home/rcmu/下载/h2-2.1.214.jar");
    InputOutput.<HashSet<String>>println(TmFileUtils.scanningJar(_file, "META-INF/services"));
  }
}
