/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class ReflectUtils {
  private static final Logger LOG = LoggerFactory.getLogger(ReflectUtils.class);
  
  public static Field[] getReflectFields(final Class<?> zlass) {
    return zlass.getDeclaredFields();
  }
  
  public static void setReflectFields(final Class<?> zlass, final String name, final Object instance, final Object value) {
    try {
      Field field = zlass.getDeclaredField(name);
      field.setAccessible(true);
      field.set(instance, value);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Method getMethod(final Class<?> zlass, final String name, final Class<?>... parameterTypes) {
    try {
      Method method = zlass.getMethod(name, parameterTypes);
      method.setAccessible(true);
      return method;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Field getReflectField(final Class<?> zlass, final String name) {
    try {
      Field field = zlass.getDeclaredField(name);
      field.setAccessible(true);
      return field;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Object newInstance(final Class<?> zlass, final Class<?>[] argsClass, final Object... constructorArgs) {
    try {
      return zlass.getDeclaredConstructor(argsClass).newInstance(constructorArgs);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Object newInstance(final Class<?> zlass, final Object... constructorArgs) {
    try {
      Object p = null;
      if (((constructorArgs != null) && (((List<Object>)Conversions.doWrapArray(constructorArgs)).size() > 0))) {
        final Function1<Object, Class<?>> _function = (Object it) -> {
          return it.getClass();
        };
        List<Class<?>> argsClass = ListExtensions.<Object, Class<?>>map(((List<Object>)Conversions.doWrapArray(constructorArgs)), _function);
        try {
          final List<Class<?>> _converted_argsClass = (List<Class<?>>)argsClass;
          p = zlass.getDeclaredConstructor(((Class<?>[])Conversions.unwrapArray(_converted_argsClass, Class.class))).newInstance(constructorArgs);
        } catch (final Throwable _t) {
          if (_t instanceof NoSuchMethodException) {
            final NoSuchMethodException e = (NoSuchMethodException)_t;
            ReflectUtils.LOG.info(e.getMessage());
            final Function1<Object, Class<?>> _function_1 = (Object it) -> {
              return it.getClass().getSuperclass();
            };
            argsClass = ListExtensions.<Object, Class<?>>map(((List<Object>)Conversions.doWrapArray(constructorArgs)), _function_1);
            final List<Class<?>> _converted_argsClass_1 = (List<Class<?>>)argsClass;
            p = zlass.getDeclaredConstructor(((Class<?>[])Conversions.unwrapArray(_converted_argsClass_1, Class.class))).newInstance(constructorArgs);
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
      } else {
        p = zlass.newInstance();
      }
      return p;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
