/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectUtils.class);

    public static Field[] getReflectFields(Class<?> zlass) {
        return zlass.getDeclaredFields();
    }

    public static void setReflectFields(Class<?> zlass, String name, Object instance, Object value) {
        try {
            Field field = zlass.getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Method getMethod(Class<?> zlass, String name, Class<?> ... parameterTypes) {
        try {
            Method method = zlass.getMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Field getReflectField(Class<?> zlass, String name) {
        try {
            Field field = zlass.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Object newInstance(Class<?> zlass, Class<?>[] argsClass, Object ... constructorArgs) {
        try {
            return zlass.getDeclaredConstructor(argsClass).newInstance(constructorArgs);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Object newInstance(Class<?> zlass, Object ... constructorArgs) {
        try {
            Object p = null;
            if (constructorArgs != null && ((List)Conversions.doWrapArray((Object)constructorArgs)).size() > 0) {
                Functions.Function1 _function = it -> it.getClass();
                List argsClass = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)constructorArgs)), (Functions.Function1)_function);
                try {
                    List _converted_argsClass = argsClass;
                    p = zlass.getDeclaredConstructor((Class[])Conversions.unwrapArray((Object)_converted_argsClass, Class.class)).newInstance(constructorArgs);
                }
                catch (Throwable _t) {
                    if (_t instanceof NoSuchMethodException) {
                        NoSuchMethodException e = (NoSuchMethodException)_t;
                        LOG.info(e.getMessage());
                        Functions.Function1 _function_1 = it -> it.getClass().getSuperclass();
                        List _converted_argsClass_1 = argsClass = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)constructorArgs)), (Functions.Function1)_function_1);
                        p = zlass.getDeclaredConstructor((Class[])Conversions.unwrapArray((Object)_converted_argsClass_1, Class.class)).newInstance(constructorArgs);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            } else {
                p = zlass.newInstance();
            }
            return p;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

