package cool.taomu.framework;

import com.google.gson.Gson;
import cool.taomu.framework.inter.IBeanContainer;
import cool.taomu.framework.inter.IConfigureManage;
import cool.taomu.framework.inter.IMQTTBroker;
import cool.taomu.framework.inter.IShareMemory;
import cool.taomu.framework.spi.TmServiceLoader;
import cool.taomu.framework.spi.annotation.Spi;
import cool.taomu.framework.utils.RuntimeInfo;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class Manager {
  @Spi(value = "mqtt_broker")
  private IMQTTBroker mqtt;
  
  @Spi(value = "taomu-configure", singleton = true)
  private IConfigureManage<?> config;
  
  @Spi(value = "TmShareMemorey")
  private IShareMemory shareMemory;
  
  private static ScheduledExecutorService monitor = Executors.newScheduledThreadPool(1);
  
  public static void main(final String[] args) {
    try {
      TmServiceLoader sl = new TmServiceLoader();
      Object _newInstance = sl.loader(IBeanContainer.class).getBean(IBeanContainer.class, 0).newInstance();
      final IBeanContainer ibean = ((IBeanContainer) _newInstance);
      Manager.evalOptions(args, ibean);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected static void evalOptions(final String[] args, final IBeanContainer beanContainer) {
    Options options = new Options();
    options.addOption("h", "help", false, "Print this usage information");
    options.addOption("c", "config", true, "设置配置文件");
    options.addOption("s", "scan", true, "设置扫描路径");
    options.addOption("m", "mqtt", false, "启动mqtt服务器");
    HelpFormatter helper = new HelpFormatter();
    try {
      DefaultParser parser = new DefaultParser();
      CommandLine cmd = parser.parse(options, args);
      boolean _hasOption = cmd.hasOption("h");
      if (_hasOption) {
        helper.printHelp("启动参数", options);
      }
      boolean _hasOption_1 = cmd.hasOption("s");
      if (_hasOption_1) {
        beanContainer.scanning(cmd.getOptionValue("scan"));
        Object _bean = beanContainer.getBean(Manager.class.getName());
        final Manager manager = ((Manager) _bean);
        manager.shareMemory.setFilename("/tmp/taomu-jvm-info.log");
        final Runnable _function = () -> {
          Gson gson = new Gson();
          RuntimeInfo _runtimeInfo = new RuntimeInfo();
          String info = gson.toJson(_runtimeInfo);
          byte[] infoByte = info.getBytes();
          final byte[] _converted_infoByte = (byte[])infoByte;
          manager.shareMemory.write(0, ((List<Byte>)Conversions.doWrapArray(_converted_infoByte)).size(), infoByte);
        };
        Manager.monitor.scheduleWithFixedDelay(_function, 1, 10, TimeUnit.SECONDS);
        boolean _hasOption_2 = cmd.hasOption("c");
        if (_hasOption_2) {
          manager.config.setConfigPath(cmd.getOptionValue("config"));
        }
        boolean _hasOption_3 = cmd.hasOption("m");
        if (_hasOption_3) {
          manager.mqtt.startTcpServer();
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof ParseException) {
        final ParseException e = (ParseException)_t;
        System.out.println(e.getMessage());
        helper.printHelp("启动参数", options);
        System.exit(0);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @Pure
  public IMQTTBroker getMqtt() {
    return this.mqtt;
  }
  
  public void setMqtt(final IMQTTBroker mqtt) {
    this.mqtt = mqtt;
  }
  
  @Pure
  public IConfigureManage<?> getConfig() {
    return this.config;
  }
  
  public void setConfig(final IConfigureManage<?> config) {
    this.config = config;
  }
  
  @Pure
  public IShareMemory getShareMemory() {
    return this.shareMemory;
  }
  
  public void setShareMemory(final IShareMemory shareMemory) {
    this.shareMemory = shareMemory;
  }
}
