package cool.taomu.framework.spi;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cool.taomu.framework.spi.annotation.Spi;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TmServiceLoader {
  private static final Logger LOG = LoggerFactory.getLogger(TmServiceLoader.class);
  
  private final String PREFIX = "META-INF/services/";
  
  private final Table<String, String, Class<?>> providers = HashBasedTable.<String, String, Class<?>>create();
  
  public TmServiceLoader() {
  }
  
  public TmServiceLoader loader(final Class<?> svc) {
    return this.loader(svc, Thread.currentThread().getContextClassLoader());
  }
  
  public TmServiceLoader loader(final Class<?> svc, final ClassLoader cloader) {
    try {
      final Class<?> service = Objects.<Class<?>>requireNonNull(svc, "class 不能为 null");
      final ClassLoader loader = ObjectUtils.<ClassLoader>defaultIfNull(cloader, ClassLoader.getSystemClassLoader());
      String _name = service.getName();
      final String fullName = (this.PREFIX + _name);
      TmServiceLoader.LOG.info("fullName : {}", fullName);
      Enumeration<URL> configs = null;
      if ((loader == null)) {
        configs = ClassLoader.getSystemResources(fullName);
      } else {
        configs = loader.getResources(fullName);
      }
      TmServiceLoader.LOG.info("Tests if this enumeration contains more elements. {}", Boolean.valueOf(configs.hasMoreElements()));
      while (configs.hasMoreElements()) {
        {
          String path = configs.nextElement().toString();
          TmServiceLoader.LOG.info(path);
          path = path.replace("file:", "");
          File _file = new File(path);
          String strs = FileUtils.readFileToString(_file, Charset.forName("UTF-8"));
          final Consumer<String> _function = (String it) -> {
            try {
              Class<?> zlass = Class.forName(it, false, loader);
              Spi alias = zlass.<Spi>getAnnotation(Spi.class);
              if (((alias != null) && (!alias.value().equals("")))) {
                this.providers.put(service.getName(), alias.value(), zlass);
              }
              this.providers.put(service.getName(), zlass.getSimpleName(), zlass);
            } catch (final Throwable _t) {
              if (_t instanceof ClassNotFoundException) {
                final ClassNotFoundException ex = (ClassNotFoundException)_t;
                TmServiceLoader.LOG.info((("类 " + it) + " 不存在"), ex);
              } else {
                throw Exceptions.sneakyThrow(_t);
              }
            }
          };
          IterableExtensions.<String>filterNull(((Iterable<String>)Conversions.doWrapArray(strs.split("\n")))).forEach(_function);
        }
      }
      return this;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public TmServiceLoader add(final Class<?> svc, final String name, final Class<?> zlass) {
    this.providers.put(svc.getName(), name, zlass);
    return this;
  }
  
  public Class<?> getBean(final Class<?> svc, final String name) {
    boolean _containsRow = this.providers.containsRow(svc.getName());
    boolean _not = (!_containsRow);
    if (_not) {
      this.loader(svc);
    }
    return this.providers.get(svc.getName(), name);
  }
  
  public Class<?> getBean(final Class<?> svc, final int index) {
    boolean _containsRow = this.providers.containsRow(svc.getName());
    boolean _not = (!_containsRow);
    if (_not) {
      this.loader(svc);
    }
    TmServiceLoader.LOG.info("service loader providers size : {}", Integer.valueOf(this.providers.size()));
    return ((Class<?>[])Conversions.unwrapArray(this.providers.row(svc.getName()).values(), Class.class))[index];
  }
}
