package cool.taomu.framework.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ByteToSize {
  public static void main(final String[] args) {
    InputOutput.<String>println(ByteToSize.sizeDescription("11258999068426"));
  }
  
  public static String sizeDescription(final String size) {
    BigDecimal bsize = new BigDecimal(size);
    DecimalFormat format = new DecimalFormat("###.0");
    BigDecimal _bigDecimal = new BigDecimal("1125899906842624");
    int _compareTo = bsize.compareTo(_bigDecimal);
    boolean _greaterThan = (_compareTo > (-1));
    if (_greaterThan) {
      BigDecimal a = new BigDecimal("1125899906842624");
      long result = bsize.divide(a).longValue();
      String _format = format.format(result);
      return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_format, "PB")));
    } else {
      BigDecimal _bigDecimal_1 = new BigDecimal("1099511627776");
      int _compareTo_1 = bsize.compareTo(_bigDecimal_1);
      boolean _greaterThan_1 = (_compareTo_1 > (-1));
      if (_greaterThan_1) {
        BigDecimal a_1 = new BigDecimal("1099511627776");
        long result_1 = bsize.divide(a_1).longValue();
        String _format_1 = format.format(result_1);
        return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_format_1, "TB")));
      } else {
        long _longValue = bsize.longValue();
        boolean _greaterEqualsThan = (_longValue >= ((1024 * 1024) * 1024));
        if (_greaterEqualsThan) {
          long _longValue_1 = bsize.longValue();
          double result_2 = (_longValue_1 / ((1024.0 * 1024.0) * 1024.0));
          String _format_2 = format.format(result_2);
          return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_format_2, "GB")));
        } else {
          long _longValue_2 = bsize.longValue();
          boolean _greaterEqualsThan_1 = (_longValue_2 >= (1024 * 1024));
          if (_greaterEqualsThan_1) {
            long _longValue_3 = bsize.longValue();
            double result_3 = (_longValue_3 / (1024.0 * 1024.0));
            String _format_3 = format.format(result_3);
            return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_format_3, "MB")));
          } else {
            long _longValue_4 = bsize.longValue();
            boolean _greaterEqualsThan_2 = (_longValue_4 >= 1024);
            if (_greaterEqualsThan_2) {
              long _longValue_5 = bsize.longValue();
              double result_4 = (_longValue_5 / 1024.0);
              String _format_4 = format.format(result_4);
              return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_format_4, "KB")));
            } else {
              long _longValue_6 = bsize.longValue();
              boolean _lessThan = (_longValue_6 < 1024);
              if (_lessThan) {
                long _longValue_7 = bsize.longValue();
                boolean _lessEqualsThan = (_longValue_7 <= 0);
                if (_lessEqualsThan) {
                  return "0B";
                } else {
                  return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(size, "B")));
                }
              }
            }
          }
        }
      }
    }
    return null;
  }
}
