package cool.taomu.framework.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TmClassLoader extends ClassLoader {
  private static final Logger LOG = LoggerFactory.getLogger(TmClassLoader.class);
  
  private Table<String, String, byte[]> providers = HashBasedTable.<String, String, byte[]>create();
  
  public TmClassLoader(final String path) {
    TmClassLoader.LOG.info(("class loader path:" + path));
    File _file = new File(path);
    Set<String> jars = TmFileUtils.scanningFile(_file);
    final Function1<String, Boolean> _function = (String it) -> {
      return Boolean.valueOf(it.endsWith(".jar"));
    };
    jars = IterableExtensions.<String>toSet(IterableExtensions.<String>filter(jars, _function));
    final Consumer<String> _function_1 = (String it) -> {
      File _file_1 = new File(it);
      HashMap<String, byte[]> jarClass = TmFileUtils.readJarClass(_file_1);
      final BiConsumer<String, byte[]> _function_2 = (String k, byte[] v) -> {
        Perl5Util p5 = new Perl5Util();
        boolean _containsRow = this.providers.containsRow(k);
        boolean _not = (!_containsRow);
        if (_not) {
          this.providers.put(k, it, v);
        } else {
          boolean _match = p5.match("/module\\-info/", k);
          boolean _not_1 = (!_match);
          if (_not_1) {
            String itVer = null;
            String kVer = null;
            int _lastIndexOf = it.lastIndexOf("/");
            int _plus = (_lastIndexOf + 1);
            String itJar = it.substring(_plus);
            Perl5Util p5ver = new Perl5Util();
            PatternMatcherInput input = new PatternMatcherInput(itJar);
            boolean _match_1 = p5ver.match("/([0-9]+[0-9\\.]+)/", input);
            if (_match_1) {
              itVer = p5ver.getMatch().toString();
            }
            String kJarPath = ((String[])Conversions.unwrapArray(this.providers.row(k).keySet(), String.class))[0];
            int _lastIndexOf_1 = kJarPath.lastIndexOf("/");
            int _plus_1 = (_lastIndexOf_1 + 1);
            String kJar = kJarPath.substring(_plus_1);
            Perl5Util _perl5Util = new Perl5Util();
            p5ver = _perl5Util;
            PatternMatcherInput _patternMatcherInput = new PatternMatcherInput(kJar);
            input = _patternMatcherInput;
            boolean _match_2 = p5ver.match("/([0-9]+[0-9\\.]+)/", input);
            if (_match_2) {
              kVer = p5ver.getMatch().toString();
            }
            boolean _greaterThan = (itVer.compareTo(kVer) > 0);
            if (_greaterThan) {
              this.providers.remove(k, kJarPath);
              this.providers.put(k, it, v);
            }
            TmClassLoader.LOG.debug(((((("类加载时出现重复类==>冲突的jar:" + itJar) + "==>已存在jar：") + kJar) + "==>冲突的类:") + k));
          }
        }
      };
      jarClass.forEach(_function_2);
    };
    jars.forEach(_function_1);
  }
  
  @Override
  public Class<?> findClass(final String name) {
    Collection<byte[]> result = this.providers.row(name).values();
    final Collection<byte[]> _converted_result = (Collection<byte[]>)result;
    int _length = ((Object[])Conversions.unwrapArray(_converted_result, Object.class)).length;
    boolean _greaterThan = (_length > 0);
    if (_greaterThan) {
      final Collection<byte[]> _converted_result_1 = (Collection<byte[]>)result;
      byte[] result2 = ((byte[][])Conversions.unwrapArray(_converted_result_1, byte[].class))[0];
      return this.defineClass(name, result2, 0, result2.length);
    }
    return null;
  }
}
