/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.container;

import cool.taomu.framework.inter.IBeanContainer;
import cool.taomu.framework.spi.TmServiceLoader;
import cool.taomu.framework.spi.annotation.ISpi;
import cool.taomu.framework.spi.annotation.Spi;
import cool.taomu.framework.utils.TmClassLoader;
import cool.taomu.framework.utils.TmFileUtils;
import cool.taomu.framework.utils.reflect.ReflectUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanContainer
implements IBeanContainer {
    private static final Logger LOG = LoggerFactory.getLogger(BeanContainer.class);
    private Map<String, TmClassLoader> tclMapping = new HashMap<String, TmClassLoader>();
    private Map<String, Object> singletonMap = new HashMap<String, Object>();
    private TmServiceLoader sloader = new TmServiceLoader();

    public BeanContainer() {
        this.singletonMap.put("TmBeanContainer", this);
    }

    @Override
    public void scanning(String path) {
        TmClassLoader tcl = new TmClassLoader(path);
        this.loadSpi(path, tcl);
        this.tclMapping.put(path, tcl);
    }

    private TmClassLoader getClassLoader(String name) {
        Functions.Function1 _function = it -> {
            try {
                Class<?> zlass = it.loadClass(name);
                if (zlass != null) {
                    return true;
                }
                return false;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        TmClassLoader tcl = (TmClassLoader)IterableExtensions.findFirst(this.tclMapping.values(), (Functions.Function1)_function);
        return tcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getBean(String name, Object ... args) {
        try {
            Class<?> zlass;
            TmClassLoader tcl = this.getClassLoader(name);
            Class<?> clazz = zlass = tcl.loadClass(name);
            synchronized (clazz) {
                Spi spi = zlass.getAnnotation(Spi.class);
                LOG.debug("getBeadn {} ", (Object)zlass.getName());
                if (spi != null && spi.singleton() && this.singletonMap.containsKey(spi.value())) {
                    LOG.debug("\u5355\u4f8b\u7c7b {}", (Object)zlass.getName());
                    return this.singletonMap.get(spi.value());
                }
                Object zlassObj = ReflectUtils.newInstance(zlass, args);
                Field[] superFields = zlass.getSuperclass().getDeclaredFields();
                Field[] fields = zlass.getDeclaredFields();
                this.fieldInstance(fields, zlassObj, name);
                this.fieldInstance(superFields, zlassObj, name);
                return zlassObj;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void fieldInstance(Field[] fields, Object zlassObj, String name) {
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            it.setAccessible(true);
            Spi spi = it.getAnnotation(Spi.class);
            _xblockexpression = spi != null && !spi.value().equals("");
            return _xblockexpression;
        };
        Consumer<Field> _function_1 = it -> {
            try {
                Spi spi = it.getAnnotation(Spi.class);
                if (spi.singleton() && this.singletonMap.containsKey(spi.value())) {
                    Object sobj = this.singletonMap.get(spi.value());
                    LOG.debug("\u4ece\u5355\u4f8b\u53d6\u503c {}", (Object)sobj.getClass().getName());
                    it.set(zlassObj, sobj);
                } else {
                    Class<?> _xifexpression = null;
                    Class<?> _svc = spi.svc();
                    boolean _tripleEquals = _svc == Void.class;
                    _xifexpression = _tripleEquals ? this.sloader.getBean(it.getType(), spi.value()) : this.sloader.getBean(spi.svc(), spi.value());
                    Class<?> tsl = _xifexpression;
                    Object instance = this.getBean(tsl.getName(), new Object[0]);
                    boolean _singleton = spi.singleton();
                    if (_singleton) {
                        LOG.debug("\u8bb0\u5f55\u5355\u4f8b\u5bf9\u8c61 {}", (Object)instance.getClass().getName());
                        this.singletonMap.put(spi.value(), instance);
                    }
                    it.set(zlassObj, instance);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    LOG.info("\u83b7\u53d6\u5b9e\u4f8b\u9519\u8bef", (Throwable)ex);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)fields)), (Functions.Function1)_function).forEach(_function_1);
    }

    @Override
    public void loadSpi(String path, ClassLoader tcl) {
        File _file = new File(path);
        Set<String> jars = TmFileUtils.scanningFile(_file);
        Functions.Function1 _function = it -> it.endsWith(".jar");
        jars = IterableExtensions.toSet((Iterable)IterableExtensions.filter(jars, (Functions.Function1)_function));
        Consumer<String> _function_1 = it -> {
            LOG.info("loadSpi:" + it);
            File _file_1 = new File((String)it);
            HashSet<String> zlassPaths = TmFileUtils.scanningJar(_file_1, null);
            Functions.Function1 _function_2 = it_1 -> it_1.endsWith(".class");
            Consumer<String> _function_3 = it_1 -> {
                block8: {
                    try {
                        boolean _not;
                        String zlassPackage = it_1.replace(".class", "").replaceAll("/", ".");
                        Perl5Util p5 = new Perl5Util();
                        boolean _match = p5.match("/module\\-info|META\\-INF/", zlassPackage);
                        boolean bl = _not = !_match;
                        if (!_not) break block8;
                        LOG.info("\u52a0\u8f7d\u7c7b:" + zlassPackage);
                        try {
                            Spi spi;
                            boolean _not_1;
                            Class<?> loader = tcl.loadClass(zlassPackage);
                            boolean _isInterface = loader.isInterface();
                            boolean bl2 = _not_1 = !_isInterface;
                            if (_not_1 && (spi = loader.getAnnotation(Spi.class)) != null) {
                                boolean _tripleEquals;
                                Class<?> _svc = spi.svc();
                                boolean bl3 = _tripleEquals = _svc == Void.class;
                                if (_tripleEquals) {
                                    Consumer<Class> _function_4 = it_2 -> {
                                        ISpi ispi = it_2.getAnnotation(ISpi.class);
                                        if (ispi != null) {
                                            this.sloader.add((Class<?>)it_2, spi.value(), loader);
                                        }
                                    };
                                    ((List)Conversions.doWrapArray(loader.getInterfaces())).forEach(_function_4);
                                } else {
                                    this.sloader.add(spi.svc(), spi.value(), loader);
                                }
                            }
                        }
                        catch (Throwable _t) {
                            if (_t instanceof NoClassDefFoundError || _t instanceof ArrayStoreException) {
                                Throwable ex = _t;
                                LOG.debug("\u8bb0\u5f55\uff1a", ex);
                                break block8;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.filter(zlassPaths, (Functions.Function1)_function_2).forEach(_function_3);
        };
        jars.forEach(_function_1);
    }
}

