/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.spi;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cool.taomu.framework.spi.annotation.Spi;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TmServiceLoader.class);
    private final String PREFIX = "META-INF/services/";
    private final Table<String, String, Class<?>> providers = HashBasedTable.create();

    public TmServiceLoader loader(Class<?> svc) {
        return this.loader(svc, Thread.currentThread().getContextClassLoader());
    }

    public TmServiceLoader loader(Class<?> svc, ClassLoader cloader) {
        try {
            Class<?> service = Objects.requireNonNull(svc, "class \u4e0d\u80fd\u4e3a null");
            ClassLoader loader = (ClassLoader)ObjectUtils.defaultIfNull((Object)cloader, (Object)ClassLoader.getSystemClassLoader());
            String _name = service.getName();
            String fullName = this.PREFIX + _name;
            LOG.info("fullName : {}", (Object)fullName);
            Enumeration<URL> configs = null;
            configs = loader == null ? ClassLoader.getSystemResources(fullName) : loader.getResources(fullName);
            LOG.info("Tests if this enumeration contains more elements. {}", (Object)configs.hasMoreElements());
            while (configs.hasMoreElements()) {
                String path = configs.nextElement().toString();
                LOG.info(path);
                path = path.replace("file:", "");
                File _file = new File(path);
                String strs = FileUtils.readFileToString((File)_file, (Charset)Charset.forName("UTF-8"));
                Consumer<String> _function = it -> {
                    try {
                        Class<?> zlass = Class.forName(it, false, loader);
                        Spi alias = zlass.getAnnotation(Spi.class);
                        if (alias != null && !alias.value().equals("")) {
                            this.providers.put((Object)service.getName(), (Object)alias.value(), zlass);
                        }
                        this.providers.put((Object)service.getName(), (Object)zlass.getSimpleName(), zlass);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ClassNotFoundException) {
                            ClassNotFoundException ex = (ClassNotFoundException)_t;
                            LOG.info("\u7c7b " + it + " \u4e0d\u5b58\u5728", (Throwable)ex);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                };
                IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)strs.split("\n")))).forEach(_function);
            }
            return this;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public TmServiceLoader add(Class<?> svc, String name, Class<?> zlass) {
        this.providers.put((Object)svc.getName(), (Object)name, zlass);
        return this;
    }

    public Class<?> getBean(Class<?> svc, String name) {
        boolean _not;
        boolean _containsRow = this.providers.containsRow((Object)svc.getName());
        boolean bl = _not = !_containsRow;
        if (_not) {
            this.loader(svc);
        }
        return (Class)this.providers.get((Object)svc.getName(), (Object)name);
    }

    public Class<?> getBean(Class<?> svc, int index) {
        boolean _not;
        boolean _containsRow = this.providers.containsRow((Object)svc.getName());
        boolean bl = _not = !_containsRow;
        if (_not) {
            this.loader(svc);
        }
        LOG.info("service loader providers size : {}", (Object)this.providers.size());
        return ((Class[])Conversions.unwrapArray(this.providers.row((Object)svc.getName()).values(), Class.class))[index];
    }
}

