/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils;

import com.sun.management.OperatingSystemMXBean;
import cool.taomu.framework.utils.ByteToSize;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
public class RuntimeInfo {
    private String vmInfo;
    private String javaInfo;
    private String jvmMemUsed;
    private String jvmMemTotal;
    private String jvmMemFree;
    private String jvmMemMax;
    private String heapMemUsed;
    private String heapMemMax;
    private String heapMemCommitted;
    private String osInfo;
    private String memUsed;
    private String memFree;
    private String memTotal;
    private int threadTotalNum;
    private String pid;
    private long loadedClassCount;
    private long totalloadedClassCount;
    private long unloadedClassCount;
    private int cpuTemp;
    private double sysCpuload;
    private double proCpuload;
    private int cpuCore;

    public RuntimeInfo() {
        try {
            long vmFree = 0L;
            long vmUse = 0L;
            long vmTotal = 0L;
            long vmMax = 0L;
            Runtime rt = Runtime.getRuntime();
            vmTotal = rt.totalMemory();
            vmFree = rt.freeMemory();
            vmMax = rt.maxMemory();
            vmUse = vmTotal - vmFree;
            this.jvmMemFree = ByteToSize.sizeDescription(String.valueOf(vmFree));
            this.jvmMemUsed = ByteToSize.sizeDescription(String.valueOf(vmUse));
            this.jvmMemTotal = ByteToSize.sizeDescription(String.valueOf(vmTotal));
            this.jvmMemMax = ByteToSize.sizeDescription(String.valueOf(vmMax));
            java.lang.management.OperatingSystemMXBean _operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            OperatingSystemMXBean osmxb = (OperatingSystemMXBean)_operatingSystemMXBean;
            String os = String.format("%s arch %s version %s", osmxb.getName(), osmxb.getArch(), osmxb.getVersion());
            this.sysCpuload = osmxb.getSystemCpuLoad();
            this.proCpuload = osmxb.getProcessCpuLoad();
            this.cpuCore = osmxb.getAvailableProcessors();
            long physicalFree = osmxb.getFreePhysicalMemorySize();
            long physicalTotal = osmxb.getTotalPhysicalMemorySize();
            long physicalUse = physicalTotal - physicalFree;
            this.osInfo = os;
            boolean _contains = this.osInfo.contains("Linux");
            if (_contains) {
                String temperature;
                boolean _equals_1;
                boolean _not;
                InputStream temp = Runtime.getRuntime().exec("cat /sys/class/thermal/thermal_zone0/temp").getInputStream();
                String temp1 = IOUtils.toString((InputStream)temp, (String)"UTF-8");
                boolean _equals = temp1.equals("");
                if (_equals) {
                    temp = Runtime.getRuntime().exec("cat /sys/class/hwmon/hwmon0/in0_input").getInputStream();
                }
                boolean bl = _not = !(_equals_1 = (temperature = IOUtils.toString((InputStream)temp, (String)"UTF-8").trim()).equals(""));
                if (_not) {
                    int _divide;
                    int _parseInt = Integer.parseInt(temperature);
                    this.cpuTemp = _divide = _parseInt / 1000;
                }
            }
            this.memFree = ByteToSize.sizeDescription(String.valueOf(physicalFree));
            this.memUsed = ByteToSize.sizeDescription(String.valueOf(physicalUse));
            this.memTotal = ByteToSize.sizeDescription(String.valueOf(physicalTotal));
            ThreadGroup parentThread = null;
            int totalThread = 0;
            parentThread = Thread.currentThread().getThreadGroup();
            while (parentThread.getParent() != null) {
                totalThread = parentThread.activeCount();
                parentThread = parentThread.getParent();
            }
            this.threadTotalNum = totalThread;
            this.pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            this.vmInfo = String.format("%s version %s", runtime.getVmName(), runtime.getVmVersion());
            this.javaInfo = String.format("%s java version %s", runtime.getVmVendor(), System.getProperty("java.version"));
            ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
            this.loadedClassCount = cl.getLoadedClassCount();
            this.totalloadedClassCount = cl.getTotalLoadedClassCount();
            this.unloadedClassCount = cl.getUnloadedClassCount();
            MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
            this.heapMemUsed = ByteToSize.sizeDescription(String.valueOf(mem.getHeapMemoryUsage().getUsed()));
            this.heapMemMax = ByteToSize.sizeDescription(String.valueOf(mem.getHeapMemoryUsage().getMax()));
            this.heapMemCommitted = ByteToSize.sizeDescription(String.valueOf(mem.getHeapMemoryUsage().getCommitted()));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void main(String[] args) {
        RuntimeInfo a = new RuntimeInfo();
        InputOutput.println((Object)a);
    }

    @Pure
    public String getVmInfo() {
        return this.vmInfo;
    }

    public void setVmInfo(String vmInfo) {
        this.vmInfo = vmInfo;
    }

    @Pure
    public String getJavaInfo() {
        return this.javaInfo;
    }

    public void setJavaInfo(String javaInfo) {
        this.javaInfo = javaInfo;
    }

    @Pure
    public String getJvmMemUsed() {
        return this.jvmMemUsed;
    }

    public void setJvmMemUsed(String jvmMemUsed) {
        this.jvmMemUsed = jvmMemUsed;
    }

    @Pure
    public String getJvmMemTotal() {
        return this.jvmMemTotal;
    }

    public void setJvmMemTotal(String jvmMemTotal) {
        this.jvmMemTotal = jvmMemTotal;
    }

    @Pure
    public String getJvmMemFree() {
        return this.jvmMemFree;
    }

    public void setJvmMemFree(String jvmMemFree) {
        this.jvmMemFree = jvmMemFree;
    }

    @Pure
    public String getJvmMemMax() {
        return this.jvmMemMax;
    }

    public void setJvmMemMax(String jvmMemMax) {
        this.jvmMemMax = jvmMemMax;
    }

    @Pure
    public String getHeapMemUsed() {
        return this.heapMemUsed;
    }

    public void setHeapMemUsed(String heapMemUsed) {
        this.heapMemUsed = heapMemUsed;
    }

    @Pure
    public String getHeapMemMax() {
        return this.heapMemMax;
    }

    public void setHeapMemMax(String heapMemMax) {
        this.heapMemMax = heapMemMax;
    }

    @Pure
    public String getHeapMemCommitted() {
        return this.heapMemCommitted;
    }

    public void setHeapMemCommitted(String heapMemCommitted) {
        this.heapMemCommitted = heapMemCommitted;
    }

    @Pure
    public String getOsInfo() {
        return this.osInfo;
    }

    public void setOsInfo(String osInfo) {
        this.osInfo = osInfo;
    }

    @Pure
    public String getMemUsed() {
        return this.memUsed;
    }

    public void setMemUsed(String memUsed) {
        this.memUsed = memUsed;
    }

    @Pure
    public String getMemFree() {
        return this.memFree;
    }

    public void setMemFree(String memFree) {
        this.memFree = memFree;
    }

    @Pure
    public String getMemTotal() {
        return this.memTotal;
    }

    public void setMemTotal(String memTotal) {
        this.memTotal = memTotal;
    }

    @Pure
    public int getThreadTotalNum() {
        return this.threadTotalNum;
    }

    public void setThreadTotalNum(int threadTotalNum) {
        this.threadTotalNum = threadTotalNum;
    }

    @Pure
    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Pure
    public long getLoadedClassCount() {
        return this.loadedClassCount;
    }

    public void setLoadedClassCount(long loadedClassCount) {
        this.loadedClassCount = loadedClassCount;
    }

    @Pure
    public long getTotalloadedClassCount() {
        return this.totalloadedClassCount;
    }

    public void setTotalloadedClassCount(long totalloadedClassCount) {
        this.totalloadedClassCount = totalloadedClassCount;
    }

    @Pure
    public long getUnloadedClassCount() {
        return this.unloadedClassCount;
    }

    public void setUnloadedClassCount(long unloadedClassCount) {
        this.unloadedClassCount = unloadedClassCount;
    }

    @Pure
    public int getCpuTemp() {
        return this.cpuTemp;
    }

    public void setCpuTemp(int cpuTemp) {
        this.cpuTemp = cpuTemp;
    }

    @Pure
    public double getSysCpuload() {
        return this.sysCpuload;
    }

    public void setSysCpuload(double sysCpuload) {
        this.sysCpuload = sysCpuload;
    }

    @Pure
    public double getProCpuload() {
        return this.proCpuload;
    }

    public void setProCpuload(double proCpuload) {
        this.proCpuload = proCpuload;
    }

    @Pure
    public int getCpuCore() {
        return this.cpuCore;
    }

    public void setCpuCore(int cpuCore) {
        this.cpuCore = cpuCore;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("vmInfo", (Object)this.vmInfo);
        b.add("javaInfo", (Object)this.javaInfo);
        b.add("jvmMemUsed", (Object)this.jvmMemUsed);
        b.add("jvmMemTotal", (Object)this.jvmMemTotal);
        b.add("jvmMemFree", (Object)this.jvmMemFree);
        b.add("jvmMemMax", (Object)this.jvmMemMax);
        b.add("heapMemUsed", (Object)this.heapMemUsed);
        b.add("heapMemMax", (Object)this.heapMemMax);
        b.add("heapMemCommitted", (Object)this.heapMemCommitted);
        b.add("osInfo", (Object)this.osInfo);
        b.add("memUsed", (Object)this.memUsed);
        b.add("memFree", (Object)this.memFree);
        b.add("memTotal", (Object)this.memTotal);
        b.add("threadTotalNum", (Object)this.threadTotalNum);
        b.add("pid", (Object)this.pid);
        b.add("loadedClassCount", (Object)this.loadedClassCount);
        b.add("totalloadedClassCount", (Object)this.totalloadedClassCount);
        b.add("unloadedClassCount", (Object)this.unloadedClassCount);
        b.add("cpuTemp", (Object)this.cpuTemp);
        b.add("sysCpuload", (Object)this.sysCpuload);
        b.add("proCpuload", (Object)this.proCpuload);
        b.add("cpuCore", (Object)this.cpuCore);
        return b.toString();
    }
}

