/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cool.taomu.framework.utils.TmFileUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TmClassLoader.class);
    private Table<String, String, byte[]> providers = HashBasedTable.create();

    public TmClassLoader(String path) {
        LOG.info("class loader path:" + path);
        File _file = new File(path);
        Set<String> jars = TmFileUtils.scanningFile(_file);
        Functions.Function1 _function = it -> it.endsWith(".jar");
        jars = IterableExtensions.toSet((Iterable)IterableExtensions.filter(jars, (Functions.Function1)_function));
        Consumer<String> _function_1 = it -> {
            File _file_1 = new File((String)it);
            HashMap<String, byte[]> jarClass = TmFileUtils.readJarClass(_file_1);
            BiConsumer<String, byte[]> _function_2 = (k, v) -> {
                boolean _not;
                Perl5Util p5 = new Perl5Util();
                boolean _containsRow = this.providers.containsRow(k);
                boolean bl = _not = !_containsRow;
                if (_not) {
                    this.providers.put(k, it, v);
                } else {
                    boolean _not_1;
                    boolean _match = p5.match("/module\\-info/", k);
                    boolean bl2 = _not_1 = !_match;
                    if (_not_1) {
                        boolean _greaterThan;
                        int _lastIndexOf_1;
                        int _plus_1;
                        String kJarPath;
                        String kJar;
                        PatternMatcherInput _patternMatcherInput;
                        Perl5Util _perl5Util;
                        boolean _match_2;
                        String itVer = null;
                        String kVer = null;
                        Perl5Util p5ver = new Perl5Util();
                        int _lastIndexOf = it.lastIndexOf("/");
                        int _plus = _lastIndexOf + 1;
                        String itJar = it.substring(_plus);
                        PatternMatcherInput input = new PatternMatcherInput(itJar);
                        boolean _match_1 = p5ver.match("/([0-9]+[0-9\\.]+)/", input);
                        if (_match_1) {
                            itVer = p5ver.getMatch().toString();
                        }
                        if (_match_2 = (p5ver = (_perl5Util = new Perl5Util())).match("/([0-9]+[0-9\\.]+)/", input = (_patternMatcherInput = new PatternMatcherInput(kJar = (kJarPath = ((String[])Conversions.unwrapArray(this.providers.row(k).keySet(), String.class))[0]).substring(_plus_1 = (_lastIndexOf_1 = kJarPath.lastIndexOf("/")) + 1))))) {
                            kVer = p5ver.getMatch().toString();
                        }
                        boolean bl3 = _greaterThan = itVer.compareTo(kVer) > 0;
                        if (_greaterThan) {
                            this.providers.remove(k, (Object)kJarPath);
                            this.providers.put(k, it, v);
                        }
                        LOG.debug("\u7c7b\u52a0\u8f7d\u65f6\u51fa\u73b0\u91cd\u590d\u7c7b==>\u51b2\u7a81\u7684jar:" + itJar + "==>\u5df2\u5b58\u5728jar\uff1a" + kJar + "==>\u51b2\u7a81\u7684\u7c7b:" + k);
                    }
                }
            };
            jarClass.forEach(_function_2);
        };
        jars.forEach(_function_1);
    }

    @Override
    public Class<?> findClass(String name) {
        boolean _greaterThan;
        Collection result = this.providers.row((Object)name).values();
        Collection _converted_result = result;
        int _length = ((Object[])Conversions.unwrapArray(_converted_result, Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            Collection _converted_result_1 = result;
            byte[] result2 = ((byte[][])Conversions.unwrapArray(_converted_result_1, byte[].class))[0];
            return this.defineClass(name, result2, 0, result2.length);
        }
        return null;
    }
}

