/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.script;

import clojure.lang.RT;
import clojure.lang.Var;
import cool.taomu.framework.inter.IScript;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class ClojureScript implements IScript {
  private static final Logger LOG = LoggerFactory.getLogger(ClojureScript.class);
  
  private String ns;
  
  public ClojureScript() {
    try {
      Class.forName("clojure.java.api.Clojure");
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public ClojureScript(final String path) {
    this();
    try {
      ClojureScript.LOG.info(String.format("加载脚本:%s", path));
      try (InputStream scriptInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(path)) {
        if ((scriptInput == null)) {
          try (FileInputStream scriptInput2 = new Function0<FileInputStream>() {
            @Override
            public FileInputStream apply() {
              try {
                File _file = new File(path);
                return new FileInputStream(_file);
              } catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
              }
            }
          }.apply()) {
            this.loaderScript(IOUtils.toString(scriptInput2, "UTF-8"));
          } catch (final Throwable _t) {
            if (_t instanceof FileNotFoundException) {
              final FileNotFoundException ex = (FileNotFoundException)_t;
              ClojureScript.LOG.info("", ex);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        } else {
          this.loaderScript(IOUtils.toString(scriptInput, "UTF-8"));
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public <K extends Object, T extends Serializable> K invoke(final String name, final T value) {
    Var foo = RT.var(this.ns, name);
    Object result = foo.invoke(value);
    K _xifexpression = null;
    if ((result != null)) {
      _xifexpression = ((K) result);
    }
    return _xifexpression;
  }
  
  @Override
  public void close() throws Exception {
    ClojureScript.LOG.debug("input stream close");
  }
  
  @Override
  public void loaderScript(final String coding) {
    StringReader _stringReader = new StringReader(coding);
    clojure.lang.Compiler.load(_stringReader);
    Perl5Util perl5 = new Perl5Util();
    boolean _match = perl5.match("/\\(ns (.*?) .*?\\)/", coding);
    if (_match) {
      this.ns = perl5.group(1);
    }
    Validate.<String>notNull(this.ns, "未获得ns值");
  }
}
