/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.script;

import clojure.lang.Compiler;
import clojure.lang.RT;
import clojure.lang.Var;
import cool.taomu.framework.inter.IScript;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClojureScript
implements IScript {
    private static final Logger LOG = LoggerFactory.getLogger(ClojureScript.class);
    private String ns;

    public ClojureScript() {
        try {
            Class.forName("clojure.java.api.Clojure");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ClojureScript(final String path) {
        block18: {
            this();
            try {
                LOG.info(String.format("\u52a0\u8f7d\u811a\u672c:%s", path));
                try (InputStream scriptInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
                    if (scriptInput == null) {
                        try (FileInputStream scriptInput2 = new Functions.Function0<FileInputStream>(){

                            public FileInputStream apply() {
                                try {
                                    File _file = new File(path);
                                    return new FileInputStream(_file);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        }.apply();){
                            this.loaderScript(IOUtils.toString((InputStream)scriptInput2, (String)"UTF-8"));
                            break block18;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof FileNotFoundException) {
                                FileNotFoundException ex = (FileNotFoundException)_t;
                                LOG.info("", (Throwable)ex);
                                break block18;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    this.loaderScript(IOUtils.toString((InputStream)scriptInput, (String)"UTF-8"));
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public <K, T extends Serializable> K invoke(String name, T value) {
        Var foo = RT.var((String)this.ns, (String)name);
        Object result = foo.invoke(value);
        Object _xifexpression = null;
        if (result != null) {
            _xifexpression = result;
        }
        return (K)_xifexpression;
    }

    public void close() throws Exception {
        LOG.debug("input stream close");
    }

    public void loaderScript(String coding) {
        StringReader _stringReader = new StringReader(coding);
        Compiler.load((Reader)_stringReader);
        Perl5Util perl5 = new Perl5Util();
        boolean _match = perl5.match("/\\(ns (.*?) .*?\\)/", coding);
        if (_match) {
            this.ns = perl5.group(1);
        }
        Validate.notNull((Object)this.ns, (String)"\u672a\u83b7\u5f97ns\u503c", (Object[])new Object[0]);
    }
}

