package cool.taomu.framework.compiler;

import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@SuppressWarnings("all")
public abstract class TaomuBaseCompiler extends AbstractProcessor {
  protected TreeMaker treeMaker;
  
  protected JavacElements elementUtils;
  
  protected Messager messager;
  
  private Class<? extends Annotation> ann;
  
  public TaomuBaseCompiler(final Class<? extends Annotation> ann) {
    this.ann = ann;
  }
  
  @Override
  public synchronized void init(final ProcessingEnvironment processingEnvironment) {
    super.init(processingEnvironment);
    Context context = ((JavacProcessingEnvironment) this.processingEnv).getContext();
    this.treeMaker = TreeMaker.instance(context);
    Elements _elementUtils = this.processingEnv.getElementUtils();
    this.elementUtils = ((JavacElements) _elementUtils);
    this.messager = this.processingEnv.getMessager();
  }
  
  @Override
  public boolean process(final Set<? extends TypeElement> annotations, final RoundEnvironment roundEnv) {
    Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(this.ann);
    if (((set == null) || (set.size() == 0))) {
      return true;
    }
    for (final Element elt : set) {
      {
        JCTree jcTree = this.elementUtils.getTree(elt);
        this.traversal(jcTree, elt);
      }
    }
    return true;
  }
  
  public abstract void traversal(final Object tree, final Element element);
  
  public void note(final String msg) {
    this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
  }
  
  protected JCTree.JCExpression _generateTypeExpression(final String fullNameOfTheClass) {
    String[] fullNameOfTheClassArray = fullNameOfTheClass.split("\\.");
    JCTree.JCIdent _Ident = this.treeMaker.Ident(this.elementUtils.getName(fullNameOfTheClassArray[0]));
    JCTree.JCExpression expr = ((JCTree.JCExpression) _Ident);
    for (int i = 1; (i < fullNameOfTheClassArray.length); i++) {
      expr = this.treeMaker.Select(expr, this.elementUtils.getName(fullNameOfTheClassArray[i]));
    }
    return expr;
  }
  
  protected JCTree.JCExpression _generateTypeExpression(final TypeTag typetag) {
    return this.treeMaker.TypeIdent(typetag);
  }
  
  public JCTree.JCNewClass newClass(final String fullName) {
    return this.treeMaker.NewClass(null, List.<JCTree.JCExpression>nil(), this.generateTypeExpression(fullName), List.<JCTree.JCExpression>nil(), null);
  }
  
  public JCTree.JCExpressionStatement call(final String fullMethod, final List args) {
    return this.treeMaker.Exec(
      this.treeMaker.Apply(List.<JCTree.JCExpression>nil(), this.generateTypeExpression(fullMethod), args));
  }
  
  public JCTree.JCExpression generateTypeExpression(final Object typetag) {
    if (typetag instanceof TypeTag) {
      return _generateTypeExpression((TypeTag)typetag);
    } else if (typetag instanceof String) {
      return _generateTypeExpression((String)typetag);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(typetag).toString());
    }
  }
}
