/**
 * Copyright (c) 2022 murenchao
 * fig is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.compiler.asm;

import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Vector;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.TraceClassVisitor;

@SuppressWarnings("all")
public class GenerateUtils {
  /**
   * 定义一个接口用来提供除构造函数外的字节码操作
   */
  public interface Asm {
    void code(final ClassVisitor visitor, final Class<?> superClass, final Class<?>[] interfaces);
  }
  
  public static void invokeDynamic(final GeneratorAdapter ga, final Class<?> zlass, final Method method, final Class<?>[] params) {
    MethodType mt = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    String _internalName = Type.getInternalName(zlass);
    String _methodDescriptorString = mt.toMethodDescriptorString();
    Handle bootstrap = new Handle(Opcodes.H_INVOKESTATIC, _internalName, "bootstrap", _methodDescriptorString, false);
    ga.invokeDynamic(method.getName(), method.getDescriptor(), bootstrap);
  }
  
  public static void invokeDynamic(final GeneratorAdapter ga, final Class<?> zlass, final Method method) {
    MethodType mt = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    String _internalName = Type.getInternalName(zlass);
    String _methodDescriptorString = mt.toMethodDescriptorString();
    Handle bootstrap = new Handle(Opcodes.H_INVOKESTATIC, _internalName, "bootstrap", _methodDescriptorString, false);
    ga.invokeDynamic(method.getName(), method.getDescriptor(), bootstrap);
  }
  
  public byte[] gen(final String className, final Class<?> superClass, final Class<?>[] interfaces, final GenerateUtils.Asm asm) {
    return this.gen(className, superClass, interfaces, asm, false);
  }
  
  /**
   * className 要生成的类名
   * superClass 要继承的父类
   * interfaces 要继承的接口
   * Asm 字节码操作
   */
  public byte[] gen(final String className, final Class<?> superClass, final Class<?>[] interfaces, final GenerateUtils.Asm asm, final boolean isDebug) {
    final ClassWriter classWriter = new ClassWriter((ClassWriter.COMPUTE_MAXS + ClassWriter.COMPUTE_FRAMES));
    PrintWriter pw = null;
    if (isDebug) {
      PrintWriter _printWriter = new PrintWriter(System.err);
      pw = _printWriter;
    }
    final ClassVisitor classVisitor = new TraceClassVisitor(classWriter, pw);
    final Vector<String> interfaceStr = new Vector<String>();
    if ((interfaces != null)) {
      final Consumer<Class<?>> _function = (Class<?> inter) -> {
        interfaceStr.add(inter.getName().replace(".", "/"));
      };
      IterableExtensions.<Class<?>>filterNull(((Iterable<Class<?>>)Conversions.doWrapArray(interfaces))).forEach(_function);
    }
    Class<?> _xifexpression = null;
    if ((superClass == null)) {
      _xifexpression = Object.class;
    } else {
      _xifexpression = superClass;
    }
    final Class<?> superZlass = _xifexpression;
    classVisitor.visit(Opcodes.V1_8, Opcodes.ACC_PUBLIC, className, null, superZlass.getTypeName().replace(".", "/"), ((String[])Conversions.unwrapArray(interfaceStr, String.class)));
    final Consumer<Constructor<?>> _function_1 = (Constructor<?> c) -> {
      Method m = Method.getMethod(c);
      final GeneratorAdapter ga = new GeneratorAdapter(Opcodes.ACC_PUBLIC, m, null, null, classVisitor);
      ga.loadThis();
      int _size = ((List<Parameter>)Conversions.doWrapArray(c.getParameters())).size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        int _size_1 = ((List<Parameter>)Conversions.doWrapArray(c.getParameters())).size();
        int _minus = (_size_1 - 1);
        ga.loadArgs(0, _minus);
      }
      ga.invokeConstructor(Type.getType(superZlass), m);
      ga.returnValue();
      ga.endMethod();
    };
    IterableExtensions.<Constructor<?>>filterNull(((Iterable<Constructor<?>>)Conversions.doWrapArray(superZlass.getConstructors()))).forEach(_function_1);
    if ((asm != null)) {
      asm.code(classVisitor, superZlass, interfaces);
    }
    classVisitor.visitEnd();
    return classWriter.toByteArray();
  }
}
