package cool.taomu.framework.compiler.asm;

import java.util.Arrays;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@SuppressWarnings("all")
public class OperationBytecodeUtils extends ClassVisitor {
  public OperationBytecodeUtils(final ClassVisitor cv) {
    super(Opcodes.V1_8, cv);
  }
  
  @Override
  public MethodVisitor visitMethod(final int access, final String name, final String desc, final String signature, final String[] exceptions) {
    MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
    boolean _equals = name.equals("method");
    if (_equals) {
      return null;
    } else {
      return methodVisitor;
    }
  }
  
  @Override
  public FieldVisitor visitField(final int i, final String s, final String s1, final String s2, final Object o) {
    boolean _equals = s.equals("age");
    if (_equals) {
      return super.visitField(i, "age1", s1, s2, o);
    }
    return super.visitField(i, s, s1, s2, o);
  }
  
  protected FieldVisitor _operation(final MethodVisitor decl, final Object... ann) {
    return null;
  }
  
  protected Object _operation(final int access, final String name, final String desc, final String signature, final String[] exceptions) {
    return null;
  }
  
  protected Object _operation(final int i, final String s, final String s1, final String s2, final Object o) {
    return null;
  }
  
  protected FieldVisitor _operation(final String decl, final Object... ann) {
    Object _get = ann[0];
    Object _get_1 = ann[1];
    Object _get_2 = ann[2];
    return super.visitField((((Integer) _get)).intValue(), decl, ((String) _get_1), ((String) _get_2), ann[3]);
  }
  
  public static void main(final String[] args) {
    Method method = cool.taomu.framework.compiler.utils.Method.getMethod("String a(int) throws Exception");
    InputOutput.<String>println(method.getDescriptor());
    final Function1<Type, String> _function = (Type it) -> {
      return it.toString();
    };
    InputOutput.<List<String>>println(ListExtensions.<Type, String>map(IterableExtensions.<Type>toList(((Iterable<Type>)Conversions.doWrapArray(method.getArgumentTypes()))), _function));
    InputOutput.<String>println(method.getReturnType().toString());
    InputOutput.<String>println(method.getName());
  }
  
  public FieldVisitor operation(final Object decl, final Object[] ann) {
    if (decl instanceof String) {
      return _operation((String)decl, ann);
    } else if (decl instanceof MethodVisitor) {
      return _operation((MethodVisitor)decl, ann);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(decl, ann).toString());
    }
  }
  
  public Object operation(final int access, final String name, final String desc, final String signature, final Object exceptions) {
    if (exceptions instanceof String[]) {
      return _operation(access, name, desc, signature, (String[])exceptions);
    } else if (exceptions != null) {
      return _operation(access, name, desc, signature, exceptions);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(access, name, desc, signature, exceptions).toString());
    }
  }
}
