package cool.taomu.framework.compiler.design.pattern.creational.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public abstract class BaseFactory<T extends Object> implements IFactory<T> {
  protected Map<String, Class<? extends T>> mapping = new HashMap<String, Class<? extends T>>();
  
  @Override
  public T getInstance(final String key, final Object... args) {
    try {
      Class<? extends T> zlass = this.mapping.get(key);
      final Function1<Object, Class<?>> _function = (Object it) -> {
        return it.getClass();
      };
      Iterable<Class<?>> argsClass = IterableExtensions.<Object, Class<?>>map(IterableExtensions.<Object>filterNull(((Iterable<Object>)Conversions.doWrapArray(args))), _function);
      final Iterable<Class<?>> _converted_argsClass = (Iterable<Class<?>>)argsClass;
      return zlass.getConstructor(((Class<?>[])Conversions.unwrapArray(_converted_argsClass, Class.class))).newInstance(args);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
