/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.compiler;

import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public abstract class TaomuBaseCompiler
extends AbstractProcessor {
    protected TreeMaker treeMaker;
    protected JavacElements elementUtils;
    protected Messager messager;
    private Class<? extends Annotation> ann;

    public TaomuBaseCompiler(Class<? extends Annotation> ann) {
        this.ann = ann;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        this.treeMaker = TreeMaker.instance(context);
        Elements _elementUtils = this.processingEnv.getElementUtils();
        this.elementUtils = (JavacElements)_elementUtils;
        this.messager = this.processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(this.ann);
        if (set == null || set.size() == 0) {
            return true;
        }
        for (Element element : set) {
            JCTree jcTree = this.elementUtils.getTree(element);
            this.traversal(jcTree, element);
        }
        return true;
    }

    public abstract void traversal(Object var1, Element var2);

    public void note(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
    }

    protected JCTree.JCExpression _generateTypeExpression(String fullNameOfTheClass) {
        JCTree.JCIdent _Ident;
        String[] fullNameOfTheClassArray = fullNameOfTheClass.split("\\.");
        JCTree.JCExpression expr = _Ident = this.treeMaker.Ident(this.elementUtils.getName(fullNameOfTheClassArray[0]));
        for (int i = 1; i < fullNameOfTheClassArray.length; ++i) {
            expr = this.treeMaker.Select(expr, this.elementUtils.getName(fullNameOfTheClassArray[i]));
        }
        return expr;
    }

    protected JCTree.JCExpression _generateTypeExpression(TypeTag typetag) {
        return this.treeMaker.TypeIdent(typetag);
    }

    public JCTree.JCNewClass newClass(String fullName) {
        return this.treeMaker.NewClass(null, List.nil(), this.generateTypeExpression(fullName), List.nil(), null);
    }

    public JCTree.JCExpressionStatement call(String fullMethod, List args) {
        return this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), this.generateTypeExpression(fullMethod), args));
    }

    public JCTree.JCExpression generateTypeExpression(Object typetag) {
        if (typetag instanceof TypeTag) {
            return this._generateTypeExpression((TypeTag)((Object)typetag));
        }
        if (typetag instanceof String) {
            return this._generateTypeExpression((String)typetag);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(typetag).toString());
    }
}

