package cool.taomu.framework.compiler.design.pattern.creational.factory;

import com.google.auto.service.AutoService;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import cool.taomu.framework.compiler.TaomuBaseCompiler;
import cool.taomu.framework.compiler.annotation.Taomu;
import cool.taomu.framework.compiler.design.annotation.Factory;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;

@SupportedAnnotationTypes({ "cool.taomu.framework.compiler.design.annotation.Factory.Product" })
@SupportedSourceVersion(SourceVersion.RELEASE_8)
@AutoService(Processor.class)
@SuppressWarnings("all")
public class FactoryProcessor extends TaomuBaseCompiler {
  public FactoryProcessor() {
    super(Taomu.class);
  }
  
  protected void _traversal(final JCTree.JCClassDecl decl, final Element element) {
    Factory.Product a = element.<Factory.Product>getAnnotation(Factory.Product.class);
    String _xifexpression = null;
    if ((a != null)) {
      _xifexpression = a.value();
    } else {
      _xifexpression = "";
    }
    this.note(_xifexpression);
    this.traversal(decl.defs, element);
  }
  
  protected void _traversal(final JCTree.JCVariableDecl decl, final Element element) {
    decl.accept(new TreeTranslator() {
      @Override
      public void visitAnnotation(final JCTree.JCAnnotation decl) {
        if ((decl.annotationType != null)) {
          FactoryProcessor.this.note(decl.annotationType.toString());
        }
        super.visitAnnotation(decl);
      }
    });
    this.note(decl.toString());
  }
  
  protected void _traversal(final List<JCTree> tree, final Element element) {
    for (final JCTree t : tree) {
      t.accept(new TreeTranslator() {
        @Override
        public void visitVarDef(final JCTree.JCVariableDecl decl) {
          FactoryProcessor.this.traversal(decl, element);
        }
      });
    }
  }
  
  public void traversal(final Object decl, final Element element) {
    if (decl instanceof JCTree.JCClassDecl) {
      _traversal((JCTree.JCClassDecl)decl, element);
      return;
    } else if (decl instanceof JCTree.JCVariableDecl) {
      _traversal((JCTree.JCVariableDecl)decl, element);
      return;
    } else if (decl instanceof List) {
      _traversal((List<JCTree>)decl, element);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(decl, element).toString());
    }
  }
}
