package cool.taomu.framework.compiler.ffi;

import com.google.auto.service.AutoService;
import cool.taomu.framework.compiler.TaomuBaseCompiler;
import cool.taomu.framework.compiler.ffi.annotation.Def;
import cool.taomu.framework.compiler.ffi.annotation.Verify;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SupportedAnnotationTypes({ "cool.taomu.framework.compiler.ffi.annotation.Def" })
@SupportedSourceVersion(SourceVersion.RELEASE_8)
@AutoService(Processor.class)
@SuppressWarnings("all")
public class FfiCompiler extends TaomuBaseCompiler {
  public FfiCompiler() {
    super(Def.class);
  }
  
  @Override
  public void traversal(final Object tree, final Element element) {
    try {
      Def a1 = element.<Def>getAnnotation(Def.class);
      Verify a2 = element.<Verify>getAnnotation(Verify.class);
      InputOutput.<String>println(IterableExtensions.<String>toList(((Iterable<String>)Conversions.doWrapArray(a1.code()))).toString());
      InputOutput.<String>println(IterableExtensions.<String>toList(((Iterable<String>)Conversions.doWrapArray(a2.code()))).toString());
      Name filename = element.getSimpleName();
      String path = System.getProperty("user.dir");
      final String filepath = IterableExtensions.join(Collections.<CharSequence>unmodifiableList(CollectionLiterals.<CharSequence>newArrayList(path, "/./libs/", filename, ".c")));
      final String os = IterableExtensions.join(Collections.<CharSequence>unmodifiableList(CollectionLiterals.<CharSequence>newArrayList(path, "/./libs/", filename, ".so")));
      String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(path, "./libs")));
      File dir = new File(_join);
      boolean _exists = dir.exists();
      boolean _not = (!_exists);
      if (_not) {
        dir.mkdirs();
      }
      boolean _exists_1 = new File(os).exists();
      boolean _not_1 = (!_exists_1);
      if (_not_1) {
        final File source = new File(filepath);
        final Consumer<String> _function = (String it) -> {
          try {
            FileUtils.writeStringToFile(source, (it + "\n"), Charset.forName("UTF-8"), true);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        IterableExtensions.<String>filterNull(((Iterable<String>)Conversions.doWrapArray(a1.code()))).forEach(_function);
        final Consumer<String> _function_1 = (String it) -> {
          try {
            FileUtils.writeStringToFile(source, (it + "\n"), Charset.forName("UTF-8"), true);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        IterableExtensions.<String>filterNull(((Iterable<String>)Conversions.doWrapArray(a2.code()))).forEach(_function_1);
        Process p = Runtime.getRuntime().exec(IterableExtensions.join(Collections.<CharSequence>unmodifiableList(CollectionLiterals.<CharSequence>newArrayList("gcc", filename, "-fPIC -shared -o ", os)), " "));
        p.waitFor();
        InputOutput.<String>println(IOUtils.toString(p.getErrorStream(), "UTF-8"));
        InputOutput.<String>println(IOUtils.toString(p.getInputStream(), "UTF-8"));
        source.delete();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
