package cool.taomu.framework.compiler.ffi;

import com.google.auto.service.AutoService;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import cool.taomu.framework.compiler.TaomuBaseCompiler;
import cool.taomu.framework.compiler.ffi.annotation.Jna;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SupportedAnnotationTypes({ "cool.taomu.framework.compiler.ffi.annotation.Jna" })
@SupportedSourceVersion(SourceVersion.RELEASE_8)
@AutoService(Processor.class)
@SuppressWarnings("all")
public class JnaCompiler extends TaomuBaseCompiler {
  public JnaCompiler() {
    super(Jna.class);
  }
  
  protected void _traversal(final JCTree.JCVariableDecl decl, final Element element) {
    this.treeMaker.pos = decl.pos;
    String vartype = decl.vartype.type.toString();
    int _lastIndexOf = vartype.lastIndexOf(".");
    int _plus = (_lastIndexOf + 1);
    String _substring = vartype.substring(_plus);
    decl.init = this.treeMaker.Apply(
      List.<JCTree.JCExpression>nil(), 
      this.generateTypeExpression("com.sun.jna.Native.load"), 
      List.<JCTree.JCExpression>of(
        this.treeMaker.Literal(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("lib", _substring, ".so")))), 
        this.generateTypeExpression(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(vartype, "class")), "."))));
    this.note(decl.toString());
  }
  
  protected void _traversal(final Object decl, final Element element) {
    this.note(decl.toString());
  }
  
  public void traversal(final Object decl, final Element element) {
    if (decl instanceof JCTree.JCVariableDecl) {
      _traversal((JCTree.JCVariableDecl)decl, element);
      return;
    } else if (decl != null) {
      _traversal(decl, element);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(decl, element).toString());
    }
  }
}
