package cool.taomu.framework.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class GitUtils {
  private final String repository = "./repository";
  
  public static void main(final String[] args) {
    GitUtils a = new GitUtils();
    a.addRemote("http://git.taomu.cool:3000/rcmu/taomu-framework.git", "gogs");
  }
  
  public Git init(final String projectName) {
    try {
      Git _xblockexpression = null;
      {
        File file = this.getRepository(projectName);
        _xblockexpression = Git.init().setDirectory(file).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public RemoteConfig addRemote(final String remoteRepository, final String name) {
    try {
      RemoteConfig _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        RemoteAddCommand _setName = git.remoteAdd().setName(name);
        URIish _uRIish = new URIish(remoteRepository);
        _xblockexpression = _setName.setUri(_uRIish).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public RemoteConfig rmRemote(final String remoteRepository, final String name) {
    try {
      RemoteConfig _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        _xblockexpression = git.remoteRemove().setRemoteName(name).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public CloneCommand clone(final String remoteRepository) {
    File file = this.getRepository(remoteRepository);
    file.mkdirs();
    return Git.cloneRepository().setURI(remoteRepository).setBare(true).setGitDir(file).setCloneAllBranches(true);
  }
  
  private File getRepository(final String remoteRepository) {
    String projectName = remoteRepository;
    boolean _contains = remoteRepository.contains("/");
    if (_contains) {
      int _lastIndexOf = remoteRepository.lastIndexOf("/");
      int _plus = (_lastIndexOf + 1);
      projectName = remoteRepository.substring(_plus);
    }
    String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.repository, projectName)), File.separator);
    return new File(_join);
  }
  
  private TransportConfigCallback getSshConfig(final String sshkeyPath) {
    return new TransportConfigCallback() {
      @Override
      public void configure(final Transport transport) {
        SshTransport sshTransport = ((SshTransport) transport);
        sshTransport.setSshSessionFactory(
          new JschConfigSessionFactory() {
            @Override
            public void configure(final OpenSshConfig.Host host, final Session session) {
              session.setConfig("StrictHostKeyChecking", "no");
            }
            
            @Override
            public JSch createDefaultJSch(final FS fs) {
              try {
                JSch jSch = super.createDefaultJSch(fs);
                jSch.addIdentity(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(sshkeyPath, "id_rsa")), File.separator));
                return jSch;
              } catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
              }
            }
          });
      }
    };
  }
  
  public String cloneBySsh(final String remoteRepository, final String sshkeyPath) {
    try {
      CloneCommand clone = this.clone(remoteRepository);
      clone.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
      try (Git git = new Function0<Git>() {
        @Override
        public Git apply() {
          try {
            return clone.call();
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        Collection<Ref> refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
        StringBuffer s = new StringBuffer();
        for (final Ref ref : refs) {
          {
            s.append(ref.getName());
            s.append("\n");
          }
        }
        s.append("clone success");
        return s.toString();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String cloneByCredentials(final String remoteRepository, final String username, final String password) {
    try {
      CloneCommand clone = this.clone(remoteRepository);
      UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
      clone.setCredentialsProvider(_usernamePasswordCredentialsProvider);
      try (Git git = new Function0<Git>() {
        @Override
        public Git apply() {
          try {
            return clone.call();
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        Collection<Ref> refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
        StringBuffer s = new StringBuffer();
        for (final Ref ref : refs) {
          {
            s.append(ref.getName());
            s.append("\n");
          }
        }
        s.append("clone success");
        return s.toString();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String pushBySsh(final String remoteRepository, final String name, final String branch, final String sshkeyPath) {
    try {
      File file = this.getRepository(remoteRepository);
      Git git = Git.open(file);
      PushCommand _push = git.push();
      RefSpec _refSpec = new RefSpec(branch);
      PushCommand push = _push.setRefSpecs(_refSpec).setRemote(name);
      push.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
      Iterable<PushResult> infos = push.call();
      StringBuffer buffer = new StringBuffer();
      for (final PushResult info : infos) {
        {
          buffer.append(info.getMessages());
          buffer.append("\n");
        }
      }
      return buffer.toString();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String pushByCredentials(final String remoteRepository, final String name, final String branch, final String username, final String password) {
    try {
      File file = this.getRepository(remoteRepository);
      Git git = Git.open(file);
      PushCommand _push = git.push();
      RefSpec _refSpec = new RefSpec(branch);
      PushCommand push = _push.setRefSpecs(_refSpec).setRemote(name);
      UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
      push.setCredentialsProvider(_usernamePasswordCredentialsProvider);
      Iterable<PushResult> infos = push.call();
      StringBuffer buffer = new StringBuffer();
      for (final PushResult info : infos) {
        {
          buffer.append(info.getMessages());
          buffer.append("\n");
        }
      }
      return buffer.toString();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String fetchBySsh(final String remoteRepository, final String sshkeyPath) {
    try {
      File file = this.getRepository(remoteRepository);
      Collection<Ref> refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
      StringBuffer log = new StringBuffer("fetch:\n");
      for (final Ref ref : refs) {
        {
          String refStr = ref.getName();
          RefSpec _refSpec = new RefSpec(((refStr + ":") + refStr));
          FetchCommand fetchCommand = Git.open(file).fetch().setRemote(remoteRepository).setRefSpecs(
            Collections.<RefSpec>unmodifiableList(CollectionLiterals.<RefSpec>newArrayList(_refSpec)));
          fetchCommand.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
          FetchResult result = fetchCommand.call();
          log.append(result.getMessages());
          log.append("\n");
        }
      }
      log.append("Fetch success");
      return log.toString();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String fetchByCredentials(final String remoteRepository, final String branch, final String username, final String password) {
    try {
      File file = this.getRepository(remoteRepository);
      Collection<Ref> refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
      StringBuffer log = new StringBuffer("fetch:\n");
      for (final Ref ref : refs) {
        {
          String refStr = ref.getName();
          RefSpec _refSpec = new RefSpec(((refStr + ":") + refStr));
          FetchCommand fetchCommand = Git.open(file).fetch().setRemote(remoteRepository).setRefSpecs(
            Collections.<RefSpec>unmodifiableList(CollectionLiterals.<RefSpec>newArrayList(_refSpec)));
          UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
          fetchCommand.setCredentialsProvider(_usernamePasswordCredentialsProvider);
          FetchResult result = fetchCommand.call();
          log.append(result.getMessages());
          log.append("\n");
        }
      }
      log.append("Fetch success");
      return log.toString();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public RevCommit commit(final String remoteRepository, final String[] files, final String msg) {
    try {
      RevCommit _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        final Git git = Git.open(file);
        final Consumer<String> _function = (String it) -> {
          try {
            git.add().addFilepattern(it).call();
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        ((List<String>)Conversions.doWrapArray(files)).forEach(_function);
        _xblockexpression = git.commit().setMessage(msg).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public RevCommit commitAll(final String remoteRepository, final String msg) {
    try {
      RevCommit _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        final Git git = Git.open(file);
        git.add().addFilepattern(".").call();
        _xblockexpression = git.commit().setMessage(msg).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public HashMap<String, String> status(final String remoteRepository) {
    try {
      HashMap<String, String> map = new HashMap<String, String>();
      File file = this.getRepository(remoteRepository);
      Git git = Git.open(file);
      Status status = git.status().call();
      map.put("Added", status.getAdded().toString());
      map.put("Changed", status.getChanged().toString());
      map.put("Conflicting", status.getConflicting().toString());
      map.put("ConflictingStageState", status.getConflictingStageState().toString());
      map.put("IgnoredNotInIndex", status.getIgnoredNotInIndex().toString());
      map.put("Missing", status.getMissing().toString());
      map.put("Modified", status.getModified().toString());
      map.put("Removed", status.getRemoved().toString());
      map.put("UntrackedFiles", status.getUntracked().toString());
      map.put("UntrackedFolders", status.getUntrackedFolders().toString());
      return map;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Ref branchCreate(final String remoteRepository, final String name) {
    try {
      Ref _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        _xblockexpression = git.branchCreate().setName(name).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public List<String> branchDelete(final String remoteRepository, final String[] names) {
    try {
      List<String> _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        _xblockexpression = git.branchDelete().setBranchNames(names).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Ref branchRename(final String remoteRepository, final String oldName, final String newName) {
    try {
      Ref _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        _xblockexpression = git.branchRename().setNewName(newName).setOldName(oldName).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public ArrayList<String> branchList(final String remoteRepository) {
    try {
      File file = this.getRepository(remoteRepository);
      Git git = Git.open(file);
      final ArrayList<String> result = CollectionLiterals.<String>newArrayList();
      final Consumer<Ref> _function = (Ref it) -> {
        result.add(it.getName());
      };
      git.branchList().call().forEach(_function);
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Ref checkout(final String remoteRepository, final String name) {
    try {
      Ref _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        CheckoutCommand _checkout = git.checkout();
        CheckoutCommand ck = _checkout.setName(name);
        _xblockexpression = ck.call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public MergeResult merge(final String remoteRepository, final String srcName, final String mergeBranch, final String mgs) {
    try {
      MergeResult _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        Git git = Git.open(file);
        Ref ref = git.checkout().setName(srcName).call();
        git.checkout().setName(mergeBranch).call();
        MergeCommand _setCommit = git.merge().include(ref).setCommit(true);
        MergeCommand merge = _setCommit.setFastForward(MergeCommand.FastForwardMode.NO_FF);
        merge.setMessage(mgs);
        _xblockexpression = merge.call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public PullResult pullByCredentials(final String remoteRepository, final String remoteBranch, final String username, final String password) {
    try {
      PullResult _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        final Git git = Git.open(file);
        PullCommand _pull = git.pull();
        PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
        UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
        pull.setCredentialsProvider(_usernamePasswordCredentialsProvider);
        _xblockexpression = pull.call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public PullResult pullBySsh(final String remoteRepository, final String remoteBranch, final String sshkeyPath) {
    try {
      PullResult _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        final Git git = Git.open(file);
        PullCommand _pull = git.pull();
        PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
        pull.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
        _xblockexpression = pull.call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Ref reset(final String remoteRepository, final String objectId) {
    try {
      Ref _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        final Git git = Git.open(file);
        Repository _repository = git.getRepository();
        RevWalk walk = new RevWalk(_repository);
        ObjectId objId = git.getRepository().resolve(objectId);
        RevCommit revCommit = walk.parseCommit(objId);
        String vision = revCommit.getParent(0).getName();
        _xblockexpression = git.reset().setMode(ResetCommand.ResetType.HARD).setRef(vision).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public RevCommit revert(final String remoteRepository, final String commitId) {
    try {
      RevCommit _xblockexpression = null;
      {
        File file = this.getRepository(remoteRepository);
        final Git git = Git.open(file);
        Repository _repository = git.getRepository();
        RevWalk walk = new RevWalk(_repository);
        RevCommit revCommit = walk.parseCommit(ObjectId.fromString(commitId));
        _xblockexpression = git.revert().include(revCommit).call();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
