/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GitUtils {
    private final String repository = "./repository";

    public static void main(String[] args) {
        GitUtils a = new GitUtils();
        a.addRemote("http://git.taomu.cool:3000/rcmu/taomu-framework.git", "gogs");
    }

    public Git init(String projectName) {
        try {
            Git _xblockexpression = null;
            File file = this.getRepository(projectName);
            _xblockexpression = Git.init().setDirectory(file).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RemoteConfig addRemote(String remoteRepository, String name) {
        try {
            RemoteConfig _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            RemoteAddCommand _setName = git.remoteAdd().setName(name);
            URIish _uRIish = new URIish(remoteRepository);
            _xblockexpression = _setName.setUri(_uRIish).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RemoteConfig rmRemote(String remoteRepository, String name) {
        try {
            RemoteConfig _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            _xblockexpression = git.remoteRemove().setRemoteName(name).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CloneCommand clone(String remoteRepository) {
        File file = this.getRepository(remoteRepository);
        file.mkdirs();
        return Git.cloneRepository().setURI(remoteRepository).setBare(true).setGitDir(file).setCloneAllBranches(true);
    }

    private File getRepository(String remoteRepository) {
        String projectName = remoteRepository;
        boolean _contains = remoteRepository.contains("/");
        if (_contains) {
            int _lastIndexOf = remoteRepository.lastIndexOf("/");
            int _plus = _lastIndexOf + 1;
            projectName = remoteRepository.substring(_plus);
        }
        String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.repository, projectName})), (CharSequence)File.separator);
        return new File(_join);
    }

    private TransportConfigCallback getSshConfig(final String sshkeyPath) {
        return new TransportConfigCallback(){

            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                    public void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }

                    public JSch createDefaultJSch(FS fs) {
                        try {
                            JSch jSch = super.createDefaultJSch(fs);
                            jSch.addIdentity(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{sshkeyPath, "id_rsa"})), (CharSequence)File.separator));
                            return jSch;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                });
            }
        };
    }

    public String cloneBySsh(String remoteRepository, String sshkeyPath) {
        String string;
        block9: {
            final CloneCommand clone = this.clone(remoteRepository);
            clone.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return clone.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Collection refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
                StringBuffer s = new StringBuffer();
                for (Ref ref : refs) {
                    s.append(ref.getName());
                    s.append("\n");
                }
                s.append("clone success");
                string = s.toString();
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return string;
    }

    public String cloneByCredentials(String remoteRepository, String username, String password) {
        String string;
        block9: {
            final CloneCommand clone = this.clone(remoteRepository);
            UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
            clone.setCredentialsProvider((CredentialsProvider)_usernamePasswordCredentialsProvider);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return clone.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Collection refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
                StringBuffer s = new StringBuffer();
                for (Ref ref : refs) {
                    s.append(ref.getName());
                    s.append("\n");
                }
                s.append("clone success");
                string = s.toString();
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return string;
    }

    public String pushBySsh(String remoteRepository, String name, String branch, String sshkeyPath) {
        try {
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            PushCommand _push = git.push();
            RefSpec _refSpec = new RefSpec(branch);
            PushCommand push = _push.setRefSpecs(new RefSpec[]{_refSpec}).setRemote(name);
            push.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
            Iterable infos = push.call();
            StringBuffer buffer = new StringBuffer();
            for (PushResult info : infos) {
                buffer.append(info.getMessages());
                buffer.append("\n");
            }
            return buffer.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String pushByCredentials(String remoteRepository, String name, String branch, String username, String password) {
        try {
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            PushCommand _push = git.push();
            RefSpec _refSpec = new RefSpec(branch);
            PushCommand push = _push.setRefSpecs(new RefSpec[]{_refSpec}).setRemote(name);
            UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
            push.setCredentialsProvider((CredentialsProvider)_usernamePasswordCredentialsProvider);
            Iterable infos = push.call();
            StringBuffer buffer = new StringBuffer();
            for (PushResult info : infos) {
                buffer.append(info.getMessages());
                buffer.append("\n");
            }
            return buffer.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String fetchBySsh(String remoteRepository, String sshkeyPath) {
        try {
            File file = this.getRepository(remoteRepository);
            Collection refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
            StringBuffer log = new StringBuffer("fetch:\n");
            for (Ref ref : refs) {
                String refStr = ref.getName();
                RefSpec _refSpec = new RefSpec(refStr + ":" + refStr);
                FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
                fetchCommand.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
                FetchResult result = fetchCommand.call();
                log.append(result.getMessages());
                log.append("\n");
            }
            log.append("Fetch success");
            return log.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String fetchByCredentials(String remoteRepository, String branch, String username, String password) {
        try {
            File file = this.getRepository(remoteRepository);
            Collection refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
            StringBuffer log = new StringBuffer("fetch:\n");
            for (Ref ref : refs) {
                String refStr = ref.getName();
                RefSpec _refSpec = new RefSpec(refStr + ":" + refStr);
                FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
                UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
                fetchCommand.setCredentialsProvider((CredentialsProvider)_usernamePasswordCredentialsProvider);
                FetchResult result = fetchCommand.call();
                log.append(result.getMessages());
                log.append("\n");
            }
            log.append("Fetch success");
            return log.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit commit(String remoteRepository, String[] files, String msg) {
        try {
            RevCommit _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            Consumer<String> _function = it -> {
                try {
                    git.add().addFilepattern(it).call();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            ((List)Conversions.doWrapArray((Object)files)).forEach(_function);
            _xblockexpression = git.commit().setMessage(msg).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit commitAll(String remoteRepository, String msg) {
        try {
            RevCommit _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            git.add().addFilepattern(".").call();
            _xblockexpression = git.commit().setMessage(msg).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public HashMap<String, String> status(String remoteRepository) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            Status status = git.status().call();
            map.put("Added", status.getAdded().toString());
            map.put("Changed", status.getChanged().toString());
            map.put("Conflicting", status.getConflicting().toString());
            map.put("ConflictingStageState", status.getConflictingStageState().toString());
            map.put("IgnoredNotInIndex", status.getIgnoredNotInIndex().toString());
            map.put("Missing", status.getMissing().toString());
            map.put("Modified", status.getModified().toString());
            map.put("Removed", status.getRemoved().toString());
            map.put("UntrackedFiles", status.getUntracked().toString());
            map.put("UntrackedFolders", status.getUntrackedFolders().toString());
            return map;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchCreate(String remoteRepository, String name) {
        try {
            Ref _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            _xblockexpression = git.branchCreate().setName(name).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<String> branchDelete(String remoteRepository, String[] names) {
        try {
            List _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            _xblockexpression = git.branchDelete().setBranchNames(names).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchRename(String remoteRepository, String oldName, String newName) {
        try {
            Ref _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            _xblockexpression = git.branchRename().setNewName(newName).setOldName(oldName).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<String> branchList(String remoteRepository) {
        try {
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            ArrayList result = CollectionLiterals.newArrayList();
            Consumer<Ref> _function = it -> result.add(it.getName());
            git.branchList().call().forEach(_function);
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref checkout(String remoteRepository, String name) {
        try {
            Ref _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            CheckoutCommand _checkout = git.checkout();
            CheckoutCommand ck = _checkout.setName(name);
            _xblockexpression = ck.call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public MergeResult merge(String remoteRepository, String srcName, String mergeBranch, String mgs) {
        try {
            MergeResult _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            Ref ref = git.checkout().setName(srcName).call();
            git.checkout().setName(mergeBranch).call();
            MergeCommand _setCommit = git.merge().include(ref).setCommit(true);
            MergeCommand merge = _setCommit.setFastForward(MergeCommand.FastForwardMode.NO_FF);
            merge.setMessage(mgs);
            _xblockexpression = merge.call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PullResult pullByCredentials(String remoteRepository, String remoteBranch, String username, String password) {
        try {
            PullResult _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            PullCommand _pull = git.pull();
            PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
            UsernamePasswordCredentialsProvider _usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
            pull.setCredentialsProvider((CredentialsProvider)_usernamePasswordCredentialsProvider);
            _xblockexpression = pull.call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PullResult pullBySsh(String remoteRepository, String remoteBranch, String sshkeyPath) {
        try {
            PullResult _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            PullCommand _pull = git.pull();
            PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
            pull.setTransportConfigCallback(this.getSshConfig(sshkeyPath));
            _xblockexpression = pull.call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref reset(String remoteRepository, String objectId) {
        try {
            Ref _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            Repository _repository = git.getRepository();
            RevWalk walk = new RevWalk(_repository);
            ObjectId objId = git.getRepository().resolve(objectId);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
            String vision = revCommit.getParent(0).getName();
            _xblockexpression = git.reset().setMode(ResetCommand.ResetType.HARD).setRef(vision).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit revert(String remoteRepository, String commitId) {
        try {
            RevCommit _xblockexpression = null;
            File file = this.getRepository(remoteRepository);
            Git git = Git.open((File)file);
            Repository _repository = git.getRepository();
            RevWalk walk = new RevWalk(_repository);
            RevCommit revCommit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)commitId));
            _xblockexpression = git.revert().include((AnyObjectId)revCommit).call();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

