/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.script;

import cool.taomu.framework.inter.IScript;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class GroovyScript implements IScript {
  private static final Logger LOG = LoggerFactory.getLogger(GroovyScript.class);
  
  private Class<Object> groovyClass = null;
  
  public GroovyScript() {
  }
  
  public GroovyScript(final String path) {
    try {
      GroovyScript.LOG.info(String.format("加载脚本:%s", path));
      ClassLoader _contextClassLoader = Thread.currentThread().getContextClassLoader();
      GroovyClassLoader gl = new GroovyClassLoader(_contextClassLoader);
      GroovyClassLoader.InnerLoader il = new GroovyClassLoader.InnerLoader(gl);
      GroovyCodeSource c = null;
      try (InputStream scriptInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(path)) {
        if ((scriptInput == null)) {
          try (FileInputStream scriptInput2 = new Function0<FileInputStream>() {
            @Override
            public FileInputStream apply() {
              try {
                File _file = new File(path);
                return new FileInputStream(_file);
              } catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
              }
            }
          }.apply()) {
            String scriptText = IOGroovyMethods.getText(scriptInput2);
            GroovyCodeSource _groovyCodeSource = new GroovyCodeSource(scriptText, path, "/groovy/script");
            c = _groovyCodeSource;
          } catch (final Throwable _t) {
            if (_t instanceof FileNotFoundException) {
              final FileNotFoundException ex = (FileNotFoundException)_t;
              GroovyScript.LOG.info("", ex);
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        } else {
          String scriptText = IOGroovyMethods.getText(scriptInput);
          GroovyCodeSource _groovyCodeSource = new GroovyCodeSource(scriptText, path, "/groovy/script");
          c = _groovyCodeSource;
        }
        this.groovyClass = il.parseClass(c);
        il.close();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void loaderScript(final String coding) {
    try {
      try (InputStream input = IOUtils.toInputStream(coding, Charset.forName("UTF-8"))) {
        ClassLoader _contextClassLoader = Thread.currentThread().getContextClassLoader();
        GroovyClassLoader gl = new GroovyClassLoader(_contextClassLoader);
        GroovyClassLoader.InnerLoader il = new GroovyClassLoader.InnerLoader(gl);
        String scriptText = IOGroovyMethods.getText(input);
        GroovyCodeSource c = new GroovyCodeSource(scriptText, "./", "/groovy/script");
        this.groovyClass = il.parseClass(c);
        il.close();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public <K extends Object, T extends Serializable> K invoke(final String name, final T value) {
    try {
      Method method = this.groovyClass.getMethod(name, value.getClass());
      method.setAccessible(true);
      Object result = method.invoke(this.groovyClass.newInstance(), value);
      K _xifexpression = null;
      if ((result != null)) {
        _xifexpression = ((K) result);
      }
      return _xifexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void close() throws Exception {
    GroovyScript.LOG.debug("input stream close");
  }
}
