/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.client.jedis;

import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.configure.entity.HostEntity;
import cool.taomu.framework.configure.entity.JeidsConfigEntity;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

public class JedisConnection
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JedisConnection.class);
    private JedisCluster cluster = null;
    private JedisPool pool = null;

    public JedisConnection(ConfigureEntity config) {
        boolean _tripleNotEquals;
        JeidsConfigEntity _jedis = config.getJedis();
        boolean bl = _tripleNotEquals = _jedis != null;
        if (_tripleNotEquals) {
            boolean _greaterThan;
            int _size = config.getJedis().getCluster().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.initJedisCluster(config);
            } else {
                this.initJedisPool(config);
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public Object getConnection() {
        try {
            if (this.cluster != null) {
                return this.cluster;
            }
            if (this.pool != null) {
                return this.pool.borrowObject();
            }
            throw new NullPointerException("jedis connection error");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private JedisPool initJedisPool(ConfigureEntity config) {
        JedisPool _xblockexpression = null;
        GenericObjectPoolConfig gopc = new GenericObjectPoolConfig();
        gopc.setMaxIdle(config.getJedis().getMaxIdle().intValue());
        gopc.setMinIdle(config.getJedis().getMinIdle().intValue());
        gopc.setMaxTotal(config.getJedis().getMaxTotal().intValue());
        gopc.setTestOnBorrow(config.getJedis().isTestOnBorrow());
        gopc.setTestOnReturn(config.getJedis().isTestOnReturn());
        String password = config.getJedis().getPassword();
        String user = config.getJedis().getUsername();
        HashSet hostAndPort = new HashSet();
        Integer timeout = config.getJedis().getTimeout();
        Consumer<HostEntity> _function = host -> {
            LOG.info("\u521b\u5efaRedis\u8fde\u63a5: {}:{}", (Object)host.getIp(), (Object)host.getPort());
            String _ip = host.getIp();
            Integer _port = host.getPort();
            HostAndPort _hostAndPort = new HostAndPort(_ip, _port.intValue());
            hostAndPort.add(_hostAndPort);
        };
        config.getJedis().getCluster().forEach(_function);
        JedisPool _xifexpression = null;
        if (user == null) {
            JedisPool _xifexpression_1 = null;
            if (password == null) {
                JedisPool _jedisPool;
                String _host = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getHost();
                int _port = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getPort();
                _xifexpression_1 = this.pool = (_jedisPool = new JedisPool(gopc, _host, _port));
            } else {
                JedisPool _jedisPool_1;
                String _host_1 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getHost();
                int _port_1 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getPort();
                _xifexpression_1 = this.pool = (_jedisPool_1 = new JedisPool(gopc, _host_1, _port_1, timeout.intValue(), password));
            }
            _xifexpression = _xifexpression_1;
        } else {
            JedisPool _xifexpression_2 = null;
            if (user != null && password != null) {
                JedisPool _jedisPool_2;
                String _host_2 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getHost();
                int _port_2 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getPort();
                _xifexpression_2 = this.pool = (_jedisPool_2 = new JedisPool(gopc, _host_2, _port_2, timeout.intValue(), user, password));
            }
            _xifexpression = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JedisPool initJedisCluster(ConfigureEntity config) {
        JedisPool _xtrycatchfinallyexpression = null;
        try {
            GenericObjectPoolConfig gopc = new GenericObjectPoolConfig();
            gopc.setMaxIdle(config.getJedis().getMaxIdle().intValue());
            gopc.setMinIdle(config.getJedis().getMinIdle().intValue());
            gopc.setMaxTotal(config.getJedis().getMaxTotal().intValue());
            gopc.setTestOnBorrow(config.getJedis().isTestOnBorrow());
            gopc.setTestOnReturn(config.getJedis().isTestOnReturn());
            HashSet hostAndPort = new HashSet();
            Consumer<HostEntity> _function = host -> {
                LOG.info("\u521b\u5efaRedis\u8fde\u63a5: {}:{}", (Object)host.getIp(), (Object)host.getPort());
                String _ip = host.getIp();
                Integer _port = host.getPort();
                HostAndPort _hostAndPort = new HostAndPort(_ip, _port.intValue());
                hostAndPort.add(_hostAndPort);
            };
            config.getJedis().getCluster().forEach(_function);
            Integer timeout = config.getJedis().getTimeout();
            Integer maxAttempts = config.getJedis().getMaxAttempts();
            String password = config.getJedis().getPassword();
            String user = config.getJedis().getUsername();
            if (user == null) {
                JedisCluster _jedisCluster_1;
                JedisCluster _jedisCluster;
                this.cluster = password == null ? (_jedisCluster = new JedisCluster(hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), gopc)) : (_jedisCluster_1 = new JedisCluster(hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), password, gopc));
            } else if (user != null && password != null) {
                JedisCluster _jedisCluster_2;
                this.cluster = _jedisCluster_2 = new JedisCluster(hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), user, password, null, gopc);
            }
            Runtime _runtime = Runtime.getRuntime();
            _runtime.addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (JedisConnection.this.cluster != null) {
                        LOG.info("addShutdownHook \u5173\u95ed\u4e86 Redis");
                        JedisConnection.this.cluster.close();
                    }
                }
            });
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                JedisPool _xblockexpression = null;
                if (this.cluster != null) {
                    LOG.info("\u5173\u95ed\u4e86 Redis");
                    this.cluster.close();
                }
                if (this.pool != null) {
                    LOG.info("\u5173\u95ed\u4e86 Redis");
                    this.pool.close();
                }
                LOG.error("\u521b\u5efaRedis\u5931\u8d25", (Throwable)e);
                this.cluster = null;
                this.pool = null;
                _xtrycatchfinallyexpression = _xblockexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }
}

