/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.cache.jedis;

import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.configure.entity.HostEntity;
import cool.taomu.framework.configure.entity.JeidsConfigEntity;
import cool.taomu.framework.crypto.Base64;
import cool.taomu.framework.inter.IConfigureManage;
import cool.taomu.framework.inter.cache.ICache;
import cool.taomu.framework.inter.cache.IQueueCache;
import cool.taomu.framework.inter.cache.ISetCache;
import cool.taomu.framework.spi.annotation.Spi;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.commands.JedisCommands;

@Spi(value="net_cache", singleton=true)
public class JedisUtils
implements AutoCloseable,
ICache<String, Serializable>,
ISetCache<String, Serializable>,
IQueueCache<String, Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(JedisUtils.class);
    private JedisCluster cluster = null;
    private JedisPool pool = null;
    @Spi(value="taomu-configure", singleton=true)
    private IConfigureManage<ConfigureEntity> config;

    private JedisPool initJedisPool() {
        boolean _tripleNotEquals;
        JedisPool _xblockexpression = null;
        ConfigureEntity config = (ConfigureEntity)this.config.loadConfig();
        JedisPool _xifexpression = null;
        JeidsConfigEntity _jedis = config.getJedis();
        boolean bl = _tripleNotEquals = _jedis != null;
        if (_tripleNotEquals) {
            JedisPool _xblockexpression_1 = null;
            GenericObjectPoolConfig gopc = new GenericObjectPoolConfig();
            gopc.setMaxIdle(config.getJedis().getMaxIdle().intValue());
            gopc.setMinIdle(config.getJedis().getMinIdle().intValue());
            gopc.setMaxTotal(config.getJedis().getMaxTotal().intValue());
            gopc.setTestOnBorrow(config.getJedis().isTestOnBorrow());
            gopc.setTestOnReturn(config.getJedis().isTestOnReturn());
            String password = config.getJedis().getPassword();
            String user = config.getJedis().getUsername();
            HashSet hostAndPort = new HashSet();
            Integer timeout = config.getJedis().getTimeout();
            Consumer<HostEntity> _function = host -> {
                LOG.info("\u521b\u5efaRedis\u8fde\u63a5: {}:{}", (Object)host.getIp(), (Object)host.getPort());
                String _ip = host.getIp();
                Integer _port = host.getPort();
                HostAndPort _hostAndPort = new HostAndPort(_ip, _port.intValue());
                hostAndPort.add(_hostAndPort);
            };
            config.getJedis().getCluster().forEach(_function);
            JedisPool _xifexpression_1 = null;
            if (user == null) {
                JedisPool _xifexpression_2 = null;
                if (password == null) {
                    JedisPool _jedisPool;
                    String _host = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getHost();
                    int _port = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getPort();
                    _xifexpression_2 = this.pool = (_jedisPool = new JedisPool(gopc, _host, _port));
                } else {
                    JedisPool _jedisPool_1;
                    String _host_1 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getHost();
                    int _port_1 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getPort();
                    _xifexpression_2 = this.pool = (_jedisPool_1 = new JedisPool(gopc, _host_1, _port_1, timeout.intValue(), password));
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                JedisPool _xifexpression_3 = null;
                if (user != null && password != null) {
                    JedisPool _jedisPool_2;
                    String _host_2 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getHost();
                    int _port_2 = ((HostAndPort[])Conversions.unwrapArray(hostAndPort, HostAndPort.class))[0].getPort();
                    _xifexpression_3 = this.pool = (_jedisPool_2 = new JedisPool(gopc, _host_2, _port_2, timeout.intValue(), user, password));
                }
                _xifexpression_1 = _xifexpression_3;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JedisPool initJedisCluster() {
        boolean _tripleNotEquals;
        Object _xblockexpression = null;
        ConfigureEntity config = (ConfigureEntity)this.config.loadConfig();
        Object _xifexpression = null;
        JeidsConfigEntity _jedis = config.getJedis();
        boolean bl = _tripleNotEquals = _jedis != null;
        if (_tripleNotEquals) {
            Object _xtrycatchfinallyexpression = null;
            try {
                GenericObjectPoolConfig gopc = new GenericObjectPoolConfig();
                gopc.setMaxIdle(config.getJedis().getMaxIdle().intValue());
                gopc.setMinIdle(config.getJedis().getMinIdle().intValue());
                gopc.setMaxTotal(config.getJedis().getMaxTotal().intValue());
                gopc.setTestOnBorrow(config.getJedis().isTestOnBorrow());
                gopc.setTestOnReturn(config.getJedis().isTestOnReturn());
                HashSet hostAndPort = new HashSet();
                Consumer<HostEntity> _function = host -> {
                    LOG.info("\u521b\u5efaRedis\u8fde\u63a5: {}:{}", (Object)host.getIp(), (Object)host.getPort());
                    String _ip = host.getIp();
                    Integer _port = host.getPort();
                    HostAndPort _hostAndPort = new HostAndPort(_ip, _port.intValue());
                    hostAndPort.add(_hostAndPort);
                };
                config.getJedis().getCluster().forEach(_function);
                Integer timeout = config.getJedis().getTimeout();
                Integer maxAttempts = config.getJedis().getMaxAttempts();
                String password = config.getJedis().getPassword();
                String user = config.getJedis().getUsername();
                if (user == null) {
                    JedisCluster _jedisCluster_1;
                    JedisCluster _jedisCluster;
                    this.cluster = password == null ? (_jedisCluster = new JedisCluster(hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), gopc)) : (_jedisCluster_1 = new JedisCluster(hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), password, gopc));
                } else if (user != null && password != null) {
                    JedisCluster _jedisCluster_2;
                    this.cluster = _jedisCluster_2 = new JedisCluster(hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), user, password, null, gopc);
                }
                Runtime _runtime = Runtime.getRuntime();
                _runtime.addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (JedisUtils.this.cluster != null) {
                            LOG.info("addShutdownHook \u5173\u95ed\u4e86 Redis");
                            JedisUtils.this.cluster.close();
                        }
                    }
                });
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    Object _xblockexpression_1 = null;
                    if (this.cluster != null) {
                        LOG.info("\u5173\u95ed\u4e86 Redis");
                        this.cluster.close();
                    }
                    if (this.pool != null) {
                        LOG.info("\u5173\u95ed\u4e86 Redis");
                        this.pool.close();
                    }
                    LOG.error("\u521b\u5efaRedis\u5931\u8d25", (Throwable)e);
                    this.cluster = null;
                    this.pool = null;
                    _xtrycatchfinallyexpression = _xblockexpression_1 = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression = _xtrycatchfinallyexpression;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public JedisCommands getJedis() {
        try {
            if (((ConfigureEntity)this.config.loadConfig()).getJedis() != null && this.pool == null && this.cluster == null) {
                LOG.info("Jedis \u94fe\u63a5\u521d\u59cb\u5316");
                boolean _isClustered = ((ConfigureEntity)this.config.loadConfig()).getJedis().isClustered();
                if (_isClustered) {
                    this.initJedisCluster();
                } else {
                    this.initJedisPool();
                }
            }
            if (this.cluster != null) {
                return this.cluster;
            }
            if (this.pool != null) {
                return (JedisCommands)this.pool.borrowObject();
            }
            throw new NullPointerException("jedis connection error");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public void clear() {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public void put(String key, Serializable value) {
        try {
            LOG.debug("\u5411Redis\u4e2d\u6dfb\u52a0{}\u6570\u636e", (Object)key);
            byte[] ser = SerializationUtils.serialize((Serializable)value);
            JedisCommands _jedis = this.getJedis();
            String _string = new String(ser, "UTF-8");
            _jedis.set(key, _string);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Serializable get(String key) {
        boolean _not;
        LOG.debug("\u4eceRedis\u4e2d\u83b7\u53d6{}\u6570\u636e", (Object)key);
        String result = this.getJedis().get(key);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)result);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _not_1;
            byte[] _bytes = result.getBytes();
            byte[] base64 = new Base64(_bytes).decode();
            byte[] _converted_base64 = base64;
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_base64)));
            boolean bl2 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return (Serializable)SerializationUtils.deserialize((byte[])base64);
            }
        }
        return null;
    }

    public void remove(String key) {
        LOG.debug("\u4eceRedis\u4e2d\u79fb\u51fa{}\u6570\u636e", (Object)key);
        this.getJedis().del(key);
    }

    public Serializable qpop(String key) {
        boolean _not;
        String result = this.getJedis().rpop(key);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)result);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _not_1;
            byte[] _bytes = result.getBytes();
            byte[] base64 = new Base64(_bytes).decode();
            byte[] _converted_base64 = base64;
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_base64)));
            boolean bl2 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return (Serializable)SerializationUtils.deserialize((byte[])base64);
            }
        }
        return null;
    }

    public void qpush(String key, Serializable value) {
        try {
            byte[] ser = SerializationUtils.serialize((Serializable)value);
            JedisCommands _jedis = this.getJedis();
            byte[] _encode = new Base64(ser).encode();
            String _string = new String(_encode, "UTF-8");
            _jedis.lpush(key, new String[]{_string});
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void sadd(String key, Serializable value) {
        try {
            byte[] ser = SerializationUtils.serialize((Serializable)value);
            JedisCommands _jedis = this.getJedis();
            byte[] _encode = new Base64(ser).encode();
            String _string = new String(_encode, "UTF-8");
            _jedis.sadd(key, new String[]{_string});
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<Serializable> sget(String key) {
        boolean _not;
        Set results = this.getJedis().smembers(key);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)results);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            HashSet<Serializable> hashSet = new HashSet<Serializable>();
            for (String result : results) {
                byte[] _bytes = result.getBytes();
                byte[] base64 = new Base64(_bytes).decode();
                byte[] _converted_base64 = base64;
                boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_base64)));
                boolean _not_1 = !_isNullOrEmpty_1;
                if (!_not_1) continue;
                hashSet.add((Serializable)SerializationUtils.deserialize((byte[])base64));
            }
            return hashSet;
        }
        return null;
    }

    public void sremove(String key, Serializable value) {
        try {
            byte[] ser = SerializationUtils.serialize((Serializable)value);
            JedisCommands _jedis = this.getJedis();
            byte[] _encode = new Base64(ser).encode();
            String _string = new String(_encode, "UTF-8");
            _jedis.srem(key, new String[]{_string});
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

