/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.script;

import cool.taomu.framework.inter.IScript;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.jruby.Ruby;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRubyScript
implements IScript {
    private static final Logger LOG = LoggerFactory.getLogger(JRubyScript.class);
    private Ruby runtime;
    private IRubyObject rubyObject;

    public JRubyScript() {
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add("/root/.jruby/lib/ruby/1.8");
        loadPaths.add("/root/.jruby/lib/ruby/site_ruby/1.8");
        this.runtime = JavaEmbedUtils.initialize(loadPaths);
    }

    public JRubyScript(final String path) {
        block18: {
            this();
            try {
                LOG.info(String.format("\u52a0\u8f7d\u811a\u672c:%s", path));
                try (InputStream scriptInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
                    if (scriptInput == null) {
                        try (FileInputStream scriptInput2 = new Functions.Function0<FileInputStream>(){

                            public FileInputStream apply() {
                                try {
                                    File _file = new File(path);
                                    return new FileInputStream(_file);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        }.apply();){
                            this.loaderScript(IOUtils.toString((InputStream)scriptInput2, (String)"UTF-8"));
                            break block18;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof FileNotFoundException) {
                                FileNotFoundException ex = (FileNotFoundException)_t;
                                LOG.info("", (Throwable)ex);
                                break block18;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    this.loaderScript(IOUtils.toString((InputStream)scriptInput, (String)"UTF-8"));
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public <K, T extends Serializable> K invoke(String name, T value) {
        Object result = JavaEmbedUtils.invokeMethod((Ruby)this.runtime, (Object)this.rubyObject, (String)name, (Object[])((Object[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new Object[]{value}), Object.class)), Object.class);
        Object _xifexpression = null;
        if (result != null) {
            _xifexpression = result;
        }
        return (K)_xifexpression;
    }

    public void close() throws Exception {
        LOG.debug("input stream close");
    }

    public void loaderScript(String coding) {
        RubyRuntimeAdapter evaler = JavaEmbedUtils.newRuntimeAdapter();
        this.rubyObject = evaler.eval(this.runtime, coding);
    }
}

